#include "pch.h"

#include "Ag.h"
//---------------------------------------------------------------------------
/*double Ag::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="w pracy podano opornosci elektryczne; oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 1. / er(iT) );
}
//---------------------------------------------------------------------------
double Ag::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return (  );
}
//---------------------------------------------------------------------------
double Ag::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2298-2299";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
	return (  );
}
//---------------------------------------------------------------------------
double Ag::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return (  );
}
//---------------------------------------------------------------------------
double Ag::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return (  );
}*/
//---------------------------------------------------------------------------
double Ag::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-10um";
	}
	
	int n=6;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.821;	f[1]     = 0.050;	f[2]     = 0.133;	f[3]     = 0.051;	f[4]     = 0.467;	f[5]     = 4.000;
	Gamma[0] = 0.049;	Gamma[1] = 0.189;	Gamma[2] = 0.067;	Gamma[3] = 0.019;	Gamma[4] = 0.117;	Gamma[5] = 0.052;
	w[0]     = 9.01;	w[1]     = 2.025;	w[2]     = 5.185;	w[3]     = 4.343;	w[4]     = 9.809;	w[5]     = 18.56;	
	sigma[0] = 0.000;	sigma[1] = 1.894;	sigma[2] = 0.665;	sigma[3] = 0.189;	sigma[4] = 1.170;	sigma[5] = 0.516;	
	
	return ( cFunc::getOptPar("nR",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
double Ag::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-10um";
	}
	
	int n=6;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.821;	f[1]     = 0.050;	f[2]     = 0.133;	f[3]     = 0.051;	f[4]     = 0.467;	f[5]     = 4.000;
	Gamma[0] = 0.049;	Gamma[1] = 0.189;	Gamma[2] = 0.067;	Gamma[3] = 0.019;	Gamma[4] = 0.117;	Gamma[5] = 0.052;
	w[0]     = 9.01;	w[1]     = 2.025;	w[2]     = 5.185;	w[3]     = 4.343;	w[4]     = 9.809;	w[5]     = 18.56;	
	sigma[0] = 0.000;	sigma[1] = 1.894;	sigma[2] = 0.665;	sigma[3] = 0.189;	sigma[4] = 1.170;	sigma[5] = 0.516;	
	
	return ( cFunc::getOptPar("abs",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
Ag::Ag()
{
}
//---------------------------------------------------------------------------
Ag::~Ag()
{
}
//---------------------------------------------------------------------------
