#include "pch.h"

#include "Al10GaN_Si.h"
//---------------------------------------------------------------------------
Al10GaN_Si::Al10GaN_Si(double _cond300K)
{ 
    k300K = _cond300K;
    sigma300K = _cond300K;
}
//---------------------------------------------------------------------------
double Al10GaN_Si::k(double T, reference *ref_ptr)
// k - przewodnosc cieplna [W/(m*K)]  
// T - temperatura [K]
// n - wykladnik potegi [-]
{
    if(ref_ptr!=NULL)
    {
        ref_ptr->reset();
        ref_ptr->author="-";
        ref_ptr->title="-";
        ref_ptr->journal="-";
        ref_ptr->comment="-";
    }
    double k = k300K*pow(T/300.0,-1.385);
    return k;
}
//---------------------------------------------------------------------------
double Al10GaN_Si::ec(double T, reference *ref_ptr)
// sigma - przewodnosc elektryczna [1/(Om*m)]
// T - temperatura [K]
// n - wykladnik potegi [-]
{
    if(ref_ptr!=NULL)
    {
        ref_ptr->reset();
        ref_ptr->author="-";
        ref_ptr->title="-";
        ref_ptr->journal="-";
        ref_ptr->comment="-";
    }
    double sigma = sigma300K*pow(T/300.0,-0.1);
    return sigma;
}
//---------------------------------------------------------------------------
