/*##############################################################################
#                                                                              #
# dane materialowe dla AlGaAs                                                  #
#                                                                              #
# data dodania pliku do bazy materialowej: 06-12-2005                          #
# data ostatniej modyfikacji: 17-04-2014                                       #
# autor kodu: LUKASZ PISKORSKI (lukasz.piskorski@p.lodz.pl)                    #
#                                                                              #
##############################################################################*/

#ifndef AlGaAs_h
#define AlGaAs_h

#include "headers.h"
#include "AlAs.h"
#include "GaAs.h"

class AlGaAs : public material // Al(x)Ga(1-x)As
{
	private:
		double mAl, mGa;
		AlAs mAlAs;
		GaAs mGaAs;

	public:
		double a(double iT, reference *ipRef=NULL);    
		double ea(reference *ipRef=NULL);
		double Eg(double iT, char iPoint, reference *ipRef=NULL);
		double Eg(double iT, reference *ipRef=NULL);
		double Dso(reference *ipRef=NULL);
		double me(reference *ipRef=NULL);
		double mhh(reference *ipRef=NULL);
		double mlh(reference *ipRef=NULL);
		double mso(reference *ipRef=NULL);
		double mh(reference *ipRef=NULL);
		double Ev(reference *ipRef=NULL);
		double Ec(double iT, reference *ipRef=NULL);
		double ac(reference *ipRef=NULL);
		double av(reference *ipRef=NULL);
		double b(reference *ipRef=NULL);
		double d(reference *ipRef=NULL);
		double c11(reference *ipRef=NULL);
		double c12(reference *ipRef=NULL);
		double c44(reference *ipRef=NULL);
		double Nc(double iT, reference *ipRef=NULL);
		double Nv(double iT, reference *ipRef=NULL);
		double ni(double iT, reference *ipRef=NULL);
		double Eact(std::string iDop, reference *ipRef=NULL);
		double Eact(double iN, std::string iDop, reference *ipRef=NULL);
		double n(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double mob(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double ec(double iT, double iN, std::string iDop, reference *ipRef=NULL); // liczyc dla: Si, C, Be; dla: Zn takze mozna, ale przyjeto n=N
		double k(double iT, reference *ipRef=NULL);
		double cp(double iT, reference *ipRef=NULL);
		double g(double iT, reference *ipRef=NULL);
		double dc(reference *ipRef=NULL);
		double nR(double iLam, double iT, reference *ipRef=NULL);
		double abs(double iLam, double iT, double iN, std::string iDop, reference *ipRef=NULL);
		AlGaAs(double iAl);
		AlGaAs();    
		virtual ~AlGaAs();
};

#endif


