#include "pch.h"

#include "AlGaAs10K.h"

//------------------------------------------------------------------------------
double AlGaAs10K::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i GaAs"; 
	}
	return ( mAl * mAlAs.me() + mGa * mGaAs.me() );
}
//------------------------------------------------------------------------------
double AlGaAs10K::mh(reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3"; 
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double AlGaAs10K::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i GaAs"; 
	}
	return ( mAl * mAlAs.mhh() + mGa * mGaAs.mhh() );
}
//------------------------------------------------------------------------------
double AlGaAs10K::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i GaAs"; 
	}
	return ( mAl * mAlAs.mlh() + mGa * mGaAs.mlh() );
}
//------------------------------------------------------------------------------
double AlGaAs10K::Eact(std::string iDop, reference *ipRef)
{
	if (iDop == "Si")
	{
		if(ipRef!=NULL)
		{
			ipRef->reset();
			ipRef->author="N. Chand, T. Henderson, J. Klem, W. T. Masselink, R. Fisger, Y.-C, Chang, and H. Morkoc";
			ipRef->title="Comprehensive analysis of Si-doped Al(x)Ga(1-x)As (x=0 to 1): Theory and experiments";
			ipRef->journal="Physical Review B, vol. 30, no. 8, pp. 4481-4492, 1984";
			ipRef->comment="na podstawie danych z Tab. I";
		}
		double iS = 160.818;
		double iA = 26.2146;
		double iB = 0.339053;
		double iX = mAl - 0.2;
		return ( (iX > 0.) ? (1e-3 * (pow((iS*iX),(iA*iB*pow(0.28,iB))) * exp(-iA*pow(iX,iB)) + 10.)) : 0.01 ); // fitowanie przez MW

		//double E_D = 0.0;
		//if(mAl == 0.0) E_D = 1;
		//else if((mAl>0.0)  && (mAl<=0.23)) E_D = 10;
		//else if((mAl>0.23) && (mAl<=0.38)) E_D = 10+817*(mAl-0.23);
		//else if((mAl>0.38) && (mAl<=0.49)) E_D = 133+260*(mAl-0.38);
		//else if((mAl>0.49) && (mAl<=0.69)) E_D = 162-333*(mAl-0.49);
		//else if((mAl>0.69) && (mAl<=1.00)) E_D = 95-123*(mAl-0.69);
		//return E_D*1e-3;
	}
	else if (iDop == "C")
	{
		if(ipRef!=NULL)
		{
			ipRef->reset();
			ipRef->author="R. Heilman and G. Oelgart";
			ipRef->title="Ionization energy of the carbon acceptor in Al(x)Ga(1-x)As";
			ipRef->journal="Semiconductor Science and Technology, vol. 5, no. 10, pp.1040-1045, 1990";
			ipRef->comment="wzor z abstractu";
		}
		return ( 1e-3 * (26.7 + 5.56*mAl + 110.*pow(mAl,3.4)) );
	}
	else
		return 0.;
}
//------------------------------------------------------------------------------
double AlGaAs10K::n(double iT, double iN, std::string iDop, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Lukasz Piskorski";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podstawie danych eksperymentalnych z roznych prac"; 
	}
	if (iDop == "Si")
		return ( cFunc::Nact('n', Eact("Si"), iN, me(), iT) );
	else if (iDop == "C")
		return ( cFunc::Nact('p', Eact("C"),  iN, mh(), iT) );
	else		
		return iN; // TODO
}
//------------------------------------------------------------------------------
double AlGaAs10K::mob(double iT, double iN, std::string iDop, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Tomasz Czyszanowski";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podstawie danych eksperymentalnych z roznych prac"; 
	}
	if (iDop == "Si")
	{
		//return( 2.9e-6*1e6*mAl*mAl*mAl - 1.96e-4*1e4*mAl*mAl - 2.8e-3*1e2*mAl + 0.275);
		return( pow(10, -0.361*mAl*mAl*mAl - 4.86*mAl*mAl + 3.78*mAl + 0.57));	//suszne dla skadu od 0.0 do 0.6 Al
	}
	else if (iDop == "C")
	{
		//return( 2.9e-6*1e6*mAl*mAl*mAl - 1.96e-4*1e4*mAl*mAl - 2.8e-3*1e2*mAl + 0.275);
		return( pow(10, -0.361*mAl*mAl*mAl - 4.86*mAl*mAl + 3.78*mAl + 0.57));	//suszne dla skadu od 0.0 do 0.6 Al
	}
	else
		return 0.;

}
//------------------------------------------------------------------------------
double AlGaAs10K::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cPhys::e * mob(iT, iN, iDop) * n(iT, iN, iDop) );       
}
//------------------------------------------------------------------------------
double AlGaAs10K::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i GaAs"; 
	} 
	return ( 1./(mAl/mAlAs.k(iT) + mGa/mGaAs.k(iT) + mAl*mGa*0.32) );
}
//------------------------------------------------------------------------------
AlGaAs10K::AlGaAs10K(double iAl)
{
	mAl = iAl;
	mGa = 1.-iAl;
}
//------------------------------------------------------------------------------
AlGaAs10K::AlGaAs10K()
{  
}
//------------------------------------------------------------------------------
AlGaAs10K::~AlGaAs10K()
{
}
//------------------------------------------------------------------------------