/*##############################################################################
#                                                                              #
# dane materialowe dla AlGaAs10K                                               #
#                                                                              #
# data dodania pliku do bazy materialowej: 22-07-2016                          #
# data ostatniej modyfikacji: 22-07-2016                                       #
# autor kodu: ROBERT SARZALA (robert.sarzala@p.lodz.pl)                        #
#                                                                              #
##############################################################################*/

#ifndef AlGaAs10K_h
#define AlGaAs10K_h

#include "headers.h"
#include "AlAs.h"
#include "GaAs.h"

class AlGaAs10K : public material // Al(x)Ga(1-x)As
{
	private:
		double mAl, mGa;
		AlAs mAlAs;
		GaAs mGaAs;

	public:
		double me(reference *ipRef=NULL);
		double mh(reference *ipRef=NULL);
		double mhh(reference *ipRef=NULL);
		double mlh(reference *ipRef=NULL);
		double Eact(std::string iDop, reference *ipRef=NULL);
		double n(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double mob(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double ec(double iT, double iN, std::string iDop, reference *ipRef=NULL); // podawac: Si, C
		double k(double iT, reference *ipRef=NULL);
		AlGaAs10K(double iAl);
		AlGaAs10K();    
		virtual ~AlGaAs10K();
};

#endif


