#include "pch.h"

#include "AlGaAs_g.h"
//------------------------------------------------------------------------------
double AlGaAs_g::k(double iT, char iDir, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="standardowe zaleznosci dla materialow warstwowych";
		ipRef->comment="k(t) = SUM(d_i)/SUM(d_i/k_i); k(l) = SUM(d_i*k_i)/SUM(d_i)";
	}
	double tSum = 0.;
	for (int i=0; i<100; i++)
	{
		double tXAl = mXAl1+i*(mXAl2-mXAl1)/99.;
		AlGaAs tAlGaAs = AlGaAs(tXAl);
		if (iDir == 't')
			tSum += (1. / tAlGaAs.k(iT));
		else if (iDir == 'l')
			tSum += tAlGaAs.k(iT);
	}
	if (iDir == 't') return (100. / tSum);
	else if (iDir == 'l') return (tSum * 0.01);
	else return 0.;
}
//------------------------------------------------------------------------------
double AlGaAs_g::ec(double iT, double iNdop, std::string iDop, char iDir, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="standardowe zaleznosci dla materialow warstwowych";
		ipRef->comment="sigma(l) = SUM(d_i*sigma_i)/SUM(d_i); sigma(t) = SUM(d_i)/SUM(d_i/sigma_i)";
	}
	double tSum = 0.;
	for (int i=0; i<100; i++)
	{
		double tXAl = mXAl1+i*(mXAl2-mXAl1)/99.;
		AlGaAs tAlGaAs = AlGaAs(tXAl);
		if (iDir == 'l')
			tSum += (cPhys::e * tAlGaAs.n(iT,iNdop,iDop) * tAlGaAs.mob(iT,iNdop,iDop));
		else if (iDir == 't')
			tSum += (1. / (cPhys::e * tAlGaAs.n(iT,iNdop,iDop) * tAlGaAs.mob(iT,iNdop,iDop)));
	}
	if (iDir == 'l') return (tSum * 0.01);
	else if (iDir == 't') return (100. / tSum);
	else return 0.;     
}
//------------------------------------------------------------------------------
AlGaAs_g::AlGaAs_g(double iXAl1, double iXAl2)
{
	mXAl1 = iXAl1;
	mXAl2 = iXAl2;
}
//------------------------------------------------------------------------------
AlGaAs_g::AlGaAs_g()
{  
}
//------------------------------------------------------------------------------
AlGaAs_g::~AlGaAs_g()
{
}
//------------------------------------------------------------------------------
