/*##############################################################################
#                                                                              #
# dane materialowe dla AlGaInP                                                 #
#                                                                              #
# data dodania pliku do bazy materialowej: 06-12-2005                          #
# data ostatniej modyfikacji: 17-12-2013                                       #
# autor kodu: LUKASZ PISKORSKI (lukasz.piskorski@p.lodz.pl)                    #
#                                                                              #
##############################################################################*/

#ifndef AlGaInP_h
#define AlGaInP_h

#include "headers.h"
#include "AlP.h"
#include "GaP.h"
#include "InP.h"

class AlGaInP: public material // Al(x)Ga(y)In(1-x-y)P
{
	private:
		double mAl, mGa, mIn;
		std::string mInt;
		AlP mAlP;
		GaP mGaP;
		InP mInP;

	public:
		double a(double iT, reference *ipRef=NULL);    
		double Eg(double iT, char iPoint, reference *ipRef=NULL);
		double Eg(double iT, reference *ipRef=NULL);
		double Dso(reference *ipRef=NULL);
		double me(reference *ipRef=NULL);
		double mhh(reference *ipRef=NULL);
		double mlh(reference *ipRef=NULL);
		double mso(reference *ipRef=NULL);
		double mh(reference *ipRef=NULL);
		double Ev(reference *ipRef=NULL);
		double Ec(double iT, reference *ipRef=NULL);
		double ac(reference *ipRef=NULL);
		double av(reference *ipRef=NULL);
		double b(reference *ipRef=NULL);
		double d(reference *ipRef=NULL);
		double c11(reference *ipRef=NULL);
		double c12(reference *ipRef=NULL);
		double c44(reference *ipRef=NULL);
		double Nc(double iT, reference *ipRef=NULL);
		double Nv(double iT, reference *ipRef=NULL);
		double ni(double iT, reference *ipRef=NULL);
		double n(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double mob(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double ec(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double k(double iT, reference *ipRef=NULL);
		double cp(double iT, reference *ipRef=NULL);
		double g(double iT, reference *ipRef=NULL);
		void setInt(std::string iInt);
		AlGaInP(double iAl, double iGa);
		AlGaInP();    
		virtual ~AlGaInP();
};
#endif


