#include "pch.h"

#include "AlGaN.h"
//---------------------------------------------------------------------------
double AlGaN::a(double iT,reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.a(iT) + mGa * mGaN.a(iT) );
}
//---------------------------------------------------------------------------
double AlGaN::c(double iT,reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.c(iT) + mGa * mGaN.c(iT) );
}
//---------------------------------------------------------------------------
double AlGaN::ea(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="http://www.ioffe.ru/SVA/NSM";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.ea() + mGa * mGaN.ea() );
}
//---------------------------------------------------------------------------
double AlGaN::Eg(double iT,reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 24";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.Eg(iT) + mGa * mGaN.Eg(iT) - mAl*mGa*0.7 );
}
//---------------------------------------------------------------------------
double AlGaN::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.Dso() + mGa * mGaN.Dso() );
}
//---------------------------------------------------------------------------
double AlGaN::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.me() + mGa * mGaN.me() );
}
//---------------------------------------------------------------------------
double AlGaN::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.mhh() + mGa * mGaN.mhh() );
}
//---------------------------------------------------------------------------
double AlGaN::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.mlh() + mGa * mGaN.mlh() );
}
//---------------------------------------------------------------------------
double AlGaN::meL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.meL() + mGa * mGaN.meL() );
}
//---------------------------------------------------------------------------
double AlGaN::meT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.meT() + mGa * mGaN.meT() );
}
//---------------------------------------------------------------------------
double AlGaN::mhhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.mhhL() + mGa * mGaN.mhhL() );
}
//---------------------------------------------------------------------------
double AlGaN::mhhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.mhhT() + mGa * mGaN.mhhT() );
}
//---------------------------------------------------------------------------
double AlGaN::mlhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.mlhL() + mGa * mGaN.mlhL() );
}
//---------------------------------------------------------------------------
double AlGaN::mlhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.mlhT() + mGa * mGaN.mlhT() );
}
//------------------------------------------------------------------------------
double AlGaN::mh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3";
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double AlGaN::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.Ev() + mGa * mGaN.Ev() );
}
//------------------------------------------------------------------------------
double AlGaN::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( Ev() + Eg(iT) );
}
//---------------------------------------------------------------------------
double AlGaN::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.c11() + mGa * mGaN.c11() );
}
//---------------------------------------------------------------------------
double AlGaN::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.c12() + mGa * mGaN.c12() );
}
//---------------------------------------------------------------------------
double AlGaN::c13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.c13() + mGa * mGaN.c13() );
}
//---------------------------------------------------------------------------
double AlGaN::c33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.c33() + mGa * mGaN.c33() );
}
//---------------------------------------------------------------------------
double AlGaN::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.c44() + mGa * mGaN.c44() );
}
//---------------------------------------------------------------------------
double AlGaN::d13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.d13() + mGa * mGaN.d13() );
}
//---------------------------------------------------------------------------
double AlGaN::d15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.d15() + mGa * mGaN.d15() );
}
//---------------------------------------------------------------------------
double AlGaN::d33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.d33() + mGa * mGaN.d33() );
}
//---------------------------------------------------------------------------
double AlGaN::e15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.e15() + mGa * mGaN.e15() );
}
//---------------------------------------------------------------------------
double AlGaN::e31(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.e31() + mGa * mGaN.e31() );
}
//---------------------------------------------------------------------------
double AlGaN::e33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.e33() + mGa * mGaN.e33() );
}
//---------------------------------------------------------------------------
double AlGaN::Psp(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.Psp() + mGa * mGaN.Psp() );
}
//---------------------------------------------------------------------------
double AlGaN::Dcr(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mAl * mAlN.Dcr() + mGa * mGaN.Dcr() );
}
//---------------------------------------------------------------------------
double AlGaN::D1(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mAl * mAlN.D1() + mGa * mGaN.D1() );
}
//---------------------------------------------------------------------------
double AlGaN::D2(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mAl * mAlN.D2() + mGa * mGaN.D2() );
}
//---------------------------------------------------------------------------
double AlGaN::D3(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mAl * mAlN.D3() + mGa * mGaN.D3() );
}
//---------------------------------------------------------------------------
double AlGaN::D4(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mAl * mAlN.D4() + mGa * mGaN.D4() );
}
//------------------------------------------------------------------------------
double AlGaN::Nc(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double AlGaN::Nv(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double AlGaN::ni(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//---------------------------------------------------------------------------
double AlGaN::n(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mGa * mGaN.n(iT,iN,iDop) + mAl * mAlN.n(iT,iN,iDop) );
}
//---------------------------------------------------------------------------
double AlGaN::mob(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	double mob(0), b(0);

	if(iDop == "Mg") { // Mg-doped
		b = 28.86-16.79*(1.-exp(-mAl/0.055))-9.26*(1-exp(-mAl/0.2));
		mob = pow(mGa,b) * mGaN.mob(iT,iN,iDop);
	}
	else { // undoped/Si-doped
		b = 1.415+19.6*exp(-5.455*mAl);
		mob = mAl * mAlN.mob(iT,iN,iDop) + pow(mGa,b) * mGaN.mob(iT,iN,iDop);
	}
	return mob;
}
//---------------------------------------------------------------------------
double AlGaN::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
    double /*sigma(0),*/ delta(0);

    // Mg-doped
    if(iDop == "Mg") {
        if(mAl < 0.7) delta = 2.7*mAl + 4.2;
        else delta = 12.2*mAl - 2.4;
    }
    else { // undoped/Si-doped
        if(mAl < 0.7) delta = 0.4*mAl - 0.2;
        else delta = 85.9*mAl*mAl - 117.8*mAl + 40.4;
    }
    return ( cPhys::e * n(300.,iN,iDop) * mob(300.,iN,iDop) * pow(iT/300.,delta) );
}
//---------------------------------------------------------------------------
double AlGaN::k(double iT, double iN, std::string iDop, reference *ipRef)
//double AlGaN::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
    double k = 1./(mAl/270. + mGa/230. + mAl*mGa*0.4),
           delta = 0.15*mAl - 1.4;

    return ( k*pow(iT/300.,delta) );
}
//---------------------------------------------------------------------------
double AlGaN::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.cp(iT) + mGa * mGaN.cp(iT) );
}
//---------------------------------------------------------------------------
double AlGaN::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.g(iT) + mGa * mGaN.g(iT) );
}
//---------------------------------------------------------------------------
double AlGaN::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 164-165";
		ipRef->comment="wartosc interpolowana z danych dla AlN i GaN";
	}
	return ( mAl * mAlN.dc() + mGa * mGaN.dc() );
}
//---------------------------------------------------------------------------
double AlGaN::nR(double iLam, double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="nR(lam,300K) dla GaN z uwzglednieniem roznicy pomiedzy Eg GaN i AlGaN";
	}

	double tE = cPhys::h_eVc1e9 / iLam;

    double nR = 0.;
    if (tE <= 1.5)
    {
        tE = 1.5;
        nR = 0.013914*tE*tE*tE*tE - 0.096422*tE*tE*tE + 0.27318*tE*tE - 0.27725*tE + 2.3535; /// wczesniej bylo, ze nR = 0
    }
    else if (tE <= 2.135872)
        nR = 0.013914*tE*tE*tE*tE - 0.096422*tE*tE*tE + 0.27318*tE*tE - 0.27725*tE + 2.3535;
    else if (tE <= 3.163507)
        nR = 0.1152*tE*tE*tE - 0.7955*tE*tE + 1.959*tE + 0.68;
    else if (tE <= 3.357226)
        nR = 18.2292*tE*tE*tE - 174.6974*tE*tE + 558.535*tE - 593.164;
    else if (tE <= 3.469242)
        nR = 33.63905*tE*tE*tE - 353.1446*tE*tE + 1235.0168*tE - 1436.09;
    else if (tE <= 3.680144)
        nR = -0.72116*tE*tE*tE + 8.8092*tE*tE - 35.8878*tE + 51.335;
    else if (tE < 4.5)
        nR = 0.351664*tE*tE*tE*tE - 6.06337*tE*tE*tE + 39.2317*tE*tE - 112.865*tE + 124.358;
    else
    {
        tE = 4.5;
        nR = 0.351664*tE*tE*tE*tE - 6.06337*tE*tE*tE + 39.2317*tE*tE - 112.865*tE + 124.358; /// wczesniej bylo, ze nR = 0
    }

    //double d = 42470. * pow(iLam,-3) - 159.2 * pow(iLam,-2) + 0.2187 * pow(iLam,-1) - 0.00003427;

	//return ( nR * pow((iT/300.), d) );

	double resAl(0.), res0(0.);
	{
        double A = 4.1446 - 1.0021 * mAl;
        double B = 190.719 - 82.999 * mAl + 27.521 * mAl * mAl;
        resAl = pow(1 + A*iLam*iLam / (iLam*iLam - B*B), 0.5);
	}
	{
        double A = 4.1446;
        double B = 190.719;
        res0 = pow(1 + A*iLam*iLam / (iLam*iLam - B*B), 0.5);
	}

	double nR_undoped = (nR * resAl / res0);
	double nR_doped = 0.;

    if ((iDop == "Si" || iDop == "O"))
	{
        double tau = 1e-14; //[s]
        double m = me() * cPhys::m0; //[kg]
        double pic2 = 2. * cMath::pi * cPhys::c;
        ////double eps = nR_undoped * nR_undoped;
        /// double n_ = n(iT,iN,iDop); zmiana 30.03.2018
        double n_ = n(300.,iN,iDop); /// zmiana 30.03.2018
        double omegaP2 = n_ * (cPhys::e)*(cPhys::e) / (m*cPhys::epsilon0);
        double omega = pic2 / (iLam*1e-9);
        double omega2 = omega*omega;
        double deps = (1.-omegaP2/(omega2+1./(tau*tau)));
        double dnR = 100.*(1.-sqrt(deps));
        nR_doped = (nR_undoped-dnR*nR_undoped/100.);
	}
	else if (iDop == "Mg")
	{
        double tau = 1e-14; //[s]
        double m = mh() * cPhys::m0; //[kg]
        double pic2 = 2. * cMath::pi * cPhys::c;
        ////double eps = nR_undoped * nR_undoped;
        //double n_ = n(iT,iN,iDop);
        double n_ = iN;
        double omegaP2 = n_ * (cPhys::e)*(cPhys::e) / (m*cPhys::epsilon0);
        double omega = pic2 / (iLam*1e-9);
        double omega2 = omega*omega;
        double deps = (1.-omegaP2/(omega2+1./(tau*tau)));
        double dnR = 100.*(1.-sqrt(deps));
        nR_doped = (nR_undoped-dnR*nR_undoped/100.);
	}
    else // czyli takze i dla p-GaN
        nR_doped = nR_undoped;

    double _dnRdT_GaN = 42470. * pow(iLam,-3) - 159.2 * pow(iLam,-2) + 0.2187 * pow(iLam,-1) - 0.00003427;
    double _dnRdT_AlN = 3486. * pow(iLam,-3) - 16.89 * pow(iLam,-2) + 0.03245 * pow(iLam,-1) - 0.000008361;
    double _dnRdT_AlGaN = mAl * _dnRdT_AlN + (1. - mAl) * _dnRdT_GaN;
    return ( nR_doped + _dnRdT_AlGaN * (iT - 300.) );
}
//---------------------------------------------------------------------------
double AlGaN::abs(double iLam, double iT, double iN, std::string iDop, reference *ipRef)
{
    /*double dE = cPhys::h_eVc1e9/iLam - Eg(iT);
	double tN = iN*1e-24;

    if (iDop=="Mg")
		return ( (19000.+200.*tN)*exp(dE/(0.019+0.0001*tN))+(330.+30.*tN)*exp(dE/(0.07+0.0008*tN)) );
    else
	{
		double tNgr = -0.0003878*iLam*iLam + 0.3946*iLam - 90.42;
		if (tN > tNgr) // Perlin
		{
			double tn = n(iT,iN,iDop)*1e-24;
			return ( (33500.*exp(0.08*tn))*exp((-0.00018*tn - 0.0135)*iLam) ); // (przed 17.01.2014 tylko taka zaleznosc dla n-GaN)
		}
		else // Piprek
			return ( (19000.+4000.*tN) * exp(dE/(0.019+0.001*tN)) + (330.+200.*tN) * exp(dE/(0.07+0.016*tN)) );
	}*/
	double dE = cPhys::h_eVc1e9/iLam - Eg(iT); // dE = E - Eg
	if ((iDop == "Si" || iDop == "O"))
	{
        double n_ = (n(iT,iN,iDop)) * 1e-24;
        if (n_ < 1.)
            n_ = 1.;
        double c1 = -18985. * pow(n_, -1.00021); // dopasowanie (P) do danych z R. Kucharski, Transparency of Semi-Insulating, n-Type, and p-Type ..., Crystals 2017, 7, 187
        double c2 = (0.40952-7.19e-3*n_+1.30887e-4*n_*n_) * pow(n_, -0.79); // dopasowanie (P) do danych z R. Kucharski, Transparency of Semi-Insulating, n-Type, and p-Type ..., Crystals 2017, 7, 187
        return ( (19000.+c1*n_) * exp(dE/(0.019+c2*n_)) + (330.+0.001*n_) * exp(dE/(0.07+0.0005*n_)) ); // postac wzoru z Piprek et al., SPIE 6766 (2007) 67660H
	}
	else
    {
        double P = iN * 1e-24;
        return ( (19000.+200.*P) * exp(dE/(0.019+0.0001*P)) + (330.+30.*P) * exp(dE/(0.07+0.0008*P)) ); //Piprek et al., SPIE 6766 (2007) 67660H
    }
}
//---------------------------------------------------------------------------
AlGaN::AlGaN(double iAl)
{
    mAl = iAl;
	mGa = 1.-iAl;
}
//---------------------------------------------------------------------------
AlGaN::AlGaN()
{
}
//---------------------------------------------------------------------------
AlGaN::~AlGaN()
{
}
