#include "pch.h"

#include "AlGaN_g.h"
//------------------------------------------------------------------------------
double AlGaN_g::k(double iT, double iNdop, std::string iDop, char iDir, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="standardowe zaleznosci dla materialow warstwowych";
		ipRef->comment="k(t) = SUM(d_i)/SUM(d_i/k_i); k(l) = SUM(d_i*k_i)/SUM(d_i)";
	}
	double tSum = 0.;
	for (int i=0; i<100; i++)
	{
		double tXAl = mXAl1+i*(mXAl2-mXAl1)/99.;
		AlGaN tAlGaN = AlGaN(tXAl);
		if (iDir == 't')
			tSum += (1. / tAlGaN.k(iT,iNdop,iDop));
		else if (iDir == 'l')
			tSum += tAlGaN.k(iT,iNdop,iDop);
	}
	if (iDir == 't') return (100. / tSum);
	else if (iDir == 'l') return (tSum * 0.01);
	else return 0.;
}
//------------------------------------------------------------------------------
double AlGaN_g::ec(double iT, double iNdop, std::string iDop, char iDir, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="standardowe zaleznosci dla materialow warstwowych";
		ipRef->comment="sigma(l) = SUM(d_i*sigma_i)/SUM(d_i); sigma(t) = SUM(d_i)/SUM(d_i/sigma_i)";
	}
	double tSum = 0.;
	for (int i=0; i<100; i++)
	{
		double tXAl = mXAl1+i*(mXAl2-mXAl1)/99.;
		AlGaN tAlGaN = AlGaN(tXAl);
		if (iDir == 'l')
			tSum += (cPhys::e * tAlGaN.n(iT,iNdop,iDop) * tAlGaN.mob(iT,iNdop,iDop));
		else if (iDir == 't')
			tSum += (1. / (cPhys::e * tAlGaN.n(iT,iNdop,iDop) * tAlGaN.mob(iT,iNdop,iDop)));
	}
	if (iDir == 'l') return (tSum * 0.01);
	else if (iDir == 't') return (100. / tSum);
	else return 0.;     
}
//------------------------------------------------------------------------------
AlGaN_g::AlGaN_g(double iXAl1, double iXAl2)
{
	mXAl1 = iXAl1;
	mXAl2 = iXAl2;
}
//------------------------------------------------------------------------------
AlGaN_g::AlGaN_g()
{  
}
//------------------------------------------------------------------------------
AlGaN_g::~AlGaN_g()
{
}
//------------------------------------------------------------------------------
