#include "pch.h"

#include "AlInAs.h"
//------------------------------------------------------------------------------
double AlInAs::cte(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="www.ioffe.ru/SVA/NSM/Semicond";
		ipRef->comment="wartosc dla In0.5Al0.5As dla T = 300 K"; 
	} 
	return 4.88e-6;
}
//------------------------------------------------------------------------------
double AlInAs::a(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.a(iT) + mIn * mInAs.a(iT) );
}
//------------------------------------------------------------------------------
double AlInAs::Eg(double iT, char iPoint, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	if (iPoint == 'G') return ( mAl * mAlAs.Eg(iT,iPoint) + mIn * mInAs.Eg(iT,iPoint) - mAl * mIn * 0.70 );
	else if (iPoint == 'X') return ( mAl * mAlAs.Eg(iT,iPoint) + mIn * mInAs.Eg(iT,iPoint) );
	else if (iPoint == 'L') return ( mAl * mAlAs.Eg(iT,iPoint) + mIn * mInAs.Eg(iT,iPoint) );
	else return 0.;
}
//------------------------------------------------------------------------------
double AlInAs::Eg(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	double tEgG = Eg(iT, 'G');
	double tEgX = Eg(iT, 'X');
	double tEgL = Eg(iT, 'L');
	if ((tEgG <= tEgX) && (tEgG <= tEgL)) return tEgG;
	else if (tEgX <= tEgL) return tEgX;
	else return tEgL;
}
//------------------------------------------------------------------------------
double AlInAs::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.Dso() + mIn * mInAs.Dso() - mAl * mIn * 0.15 );
}
//------------------------------------------------------------------------------
double AlInAs::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs"; 
	}
	return ( mAl * mAlAs.me() + mIn * mInAs.me() - mAl * mIn * 0.012 );
}
//------------------------------------------------------------------------------
double AlInAs::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs"; 
	}
	return ( mAl * mAlAs.mhh() + mIn * mInAs.mhh() );
}
//------------------------------------------------------------------------------
double AlInAs::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs"; 
	}
	return ( mAl * mAlAs.mlh() + mIn * mInAs.mlh() );
}
//------------------------------------------------------------------------------
double AlInAs::mso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.mso() + mIn * mInAs.mso() );
}
//------------------------------------------------------------------------------
double AlInAs::mh(reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3"; 
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double AlInAs::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs; punktem odniesienia jest Ev=0eV dla InSb";
	}
	return ( mAl * mAlAs.Ev() + mIn * mInAs.Ev() - mAl * mIn * (-0.64) );
}
//------------------------------------------------------------------------------
double AlInAs::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( Ev() + Eg(iT) );
}
//------------------------------------------------------------------------------
double AlInAs::ac(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.ac() + mIn * mInAs.ac() - mAl * mIn * (-1.4) );
}
//------------------------------------------------------------------------------
double AlInAs::av(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.av() + mIn * mInAs.av() );
}
//------------------------------------------------------------------------------
double AlInAs::b(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.b() + mIn * mInAs.b() );
}
//------------------------------------------------------------------------------
double AlInAs::d(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.d() + mIn * mInAs.d() );
}
//------------------------------------------------------------------------------
double AlInAs::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.c11() + mIn * mInAs.c11() );
}
//------------------------------------------------------------------------------
double AlInAs::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.c12() + mIn * mInAs.c12() );
}
//------------------------------------------------------------------------------
double AlInAs::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs";
	}
	return ( mAl * mAlAs.c44() + mIn * mInAs.c44() );
}
//------------------------------------------------------------------------------
double AlInAs::Nc(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double AlInAs::Nv(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double AlInAs::ni(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//------------------------------------------------------------------------------
double AlInAs::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs"; 
	} 
	return ( 1./(mAl/mAlAs.k(iT) + mIn/mInAs.k(iT) + mAl*mIn*0.15) );
}
//------------------------------------------------------------------------------
double AlInAs::cp(double iT, reference *ipRef)
{
	double tcp = 0.;
	if(ipRef!=NULL)
	{
		if (mIn > 0.46 && mIn < 0.51)
		{
			ipRef->reset();
			ipRef->author="S. Adachi";
			ipRef->title="Handbook on Physical Properties of Semiconductors, vol. 2 III-V Compound Semiconductors, Chapter 16";
			ipRef->journal="Kluwer Academic Publishers, 2004";
			ipRef->comment="dla T: 300-1200 K"; 
			tcp = 125*pow(iT,0.17);
		}
		else {
			ipRef->reset();
			ipRef->author="S. Adachi";
			ipRef->title="Properties of Semiconductors Alloys";
			ipRef->journal="John Wiley and Sons, 2009";
			ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs"; 
			tcp = mAl * mAlAs.cp(iT) + mIn * mInAs.cp(iT);
		}
	}
	
	return ( tcp );
}
//------------------------------------------------------------------------------
double AlInAs::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla AlAs i InAs"; 
	}
	return ( mAl * mAlAs.g(iT) + mIn * mInAs.g(iT) );
}
//------------------------------------------------------------------------------
AlInAs::AlInAs(double iAl)
{
	mAl = iAl;
	mIn = 1.-iAl;
}
//------------------------------------------------------------------------------
AlInAs::AlInAs()
{  
}
//------------------------------------------------------------------------------
AlInAs::~AlInAs()
{
}
//------------------------------------------------------------------------------