#include "pch.h"

#include "AlInN.h"
//------------------------------------------------------------------------------
double AlInN::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Jing Zhang, Hua Tong, Guangyu Liu, Juan A. Herbsommer, G. S. Huang and Nelson Tansu";
		ipRef->title="Thermoelectric Properties of MOCVD-Grown AlInN Alloys with Various Compositions";
		ipRef->journal="Proc. of SPIE Vol. 7939, 79390O , 2011";
		ipRef->comment="dane dla materialu dopasowanego tzn. z 17% In";
	}
	return ( 4.87 );
}
//------------------------------------------------------------------------------
double AlInN::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Kazuki Ikeyama, Yugo Kozuka, Kenjo Matsui, ..., and Isamu Akasaki";
		ipRef->title="Room-temperature continuous-wave operation of GaN VCSEL with n-type conducting AlInN/GaN DBR";
		ipRef->journal="Applied Physics Express 9, 102101, 2016";
		ipRef->comment="podano rzad wielkosci dla zwierciadel DBR z 17% In";
		//oszacowano na podstawie informacji: 46 par zwierciadla DBR posiadalo opornosc 7.810-4 Ohm cm2
	}
	return ( 10 );
}
//------------------------------------------------------------------------------
double AlInN::nR(double iLam, double iT, reference *ipRef)
{
	//Sellmeier equation: nr (L [nm]) = [3.05+1.54*L^2/(L^2-229.39^2)]^0.5
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J.-F. Carlin, C. Zellweger, ..., and N. Grandjean";
		ipRef->title="Progresses in III-nitride DBR and microcavities using AlInN/GaN materials";
		ipRef->journal="phys. stat. sol. (b) 242, No. 11, 23262344 (2005)";
		ipRef->comment="oszacowal Maciej Kuc";
	}
	
	return ( sqrt(3.05 + 1.54*pow(iLam,2.)/(pow(iLam,2.) - pow(229.39,2.))) );
}
//------------------------------------------------------------------------------
double AlInN::abs(double iLam, double iT, reference *ipRef)
{
	//absorpcja: abs (L [nm]) = 3.56e11*L^-3.73 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J.-F. Carlin, C. Zellweger, ..., and N. Grandjean";
		ipRef->title="Progresses in III-nitride DBR and microcavities using AlInN/GaN materials";
		ipRef->journal="phys. stat. sol. (b) 242, No. 11, 23262344 (2005)";
		ipRef->comment="oszacowal Maciej Kuc";
	}
	
    return ( 3.57e11*pow(iLam,-3.73) );
} 
//---------------------------------------------------------------------------
AlInN::AlInN()
{
}
//---------------------------------------------------------------------------
AlInN::~AlInN()
{
}


