#include "pch.h"

#include "AlN.h"
//---------------------------------------------------------------------------
double AlN::a(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 3.112;
}
//---------------------------------------------------------------------------
double AlN::c(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 4.982;
}
//---------------------------------------------------------------------------
double AlN::ea(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="http://www.ioffe.ru/SVA/NSM";
		ipRef->comment="-";
	}
	return 0.6;
}
//---------------------------------------------------------------------------
double AlN::Eg(double iT,reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 24";
		ipRef->comment="-";
	}
	return ( cFunc::Varshni(6.10, 2.63e-3, 2082., iT) );
}
//---------------------------------------------------------------------------
double AlN::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 0.019;
}
//---------------------------------------------------------------------------
double AlN::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc srednia z przedzialu 0.25-0.4 m0";
	}
	return 0.31;
}
//---------------------------------------------------------------------------
double AlN::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="-";
	}
	return 3.53;
}
//---------------------------------------------------------------------------
double AlN::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="-";
	}
	return 3.53;
}
//---------------------------------------------------------------------------
double AlN::meL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment=" ";
	}
	return 0.30;
}
//---------------------------------------------------------------------------
double AlN::meT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment=" ";
	}
	return 0.29;
}
//---------------------------------------------------------------------------
double AlN::mhhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A1+A3), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 2.56;
}
//---------------------------------------------------------------------------
double AlN::mhhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A2+A4-A5), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 4.17;
}
//---------------------------------------------------------------------------
double AlN::mlhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A1+A3), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 2.56;
}
//---------------------------------------------------------------------------
double AlN::mlhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A2+A4+A5), wzor z pracy: Phys.Rev.B, 69, 165204, 2004 z uwzgl. APL, 67 (17), 2527-9, 1995";
	}
	return 0.27;
}
//------------------------------------------------------------------------------
double AlN::mh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3";
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double AlN::Ev(reference *ipRef)
{
    if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Yi-Chia Tsai and Can Bayram";
		ipRef->title="Band Alignments of Ternary Wurtzite and Zincblende III-Nitrides Investigated by Hybrid Density Functional Theory";
		ipRef->journal="ACS Omega 2020, 5, 8, 39173923. https://doi.org/10.1021/acsomega.9b03353";
		ipRef->comment=" ";
	}
	return ( -0.30 );
	/*if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 0.0 );*/
	//return ( -3.44 );
}
//------------------------------------------------------------------------------
double AlN::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( Ev() + Eg(iT) );
}
//---------------------------------------------------------------------------
double AlN::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 396;
}
//---------------------------------------------------------------------------
double AlN::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 137.;
}
//---------------------------------------------------------------------------
double AlN::c13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 108.;
}
//---------------------------------------------------------------------------
double AlN::c33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 373.;
}
//---------------------------------------------------------------------------
double AlN::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 116.;
}
//---------------------------------------------------------------------------
double AlN::d13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -2.1;
}
//---------------------------------------------------------------------------
double AlN::d15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 3.6;
}
//---------------------------------------------------------------------------
double AlN::d33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 5.4;
}
//---------------------------------------------------------------------------
double AlN::e15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return -0.351;
}
//---------------------------------------------------------------------------
double AlN::e31(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return -0.533;
}
//---------------------------------------------------------------------------
double AlN::e33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return 1.505;
}
//---------------------------------------------------------------------------
double AlN::Psp(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -0.090;
}
//---------------------------------------------------------------------------
double AlN::Dcr(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -0.169;
}
//---------------------------------------------------------------------------
double AlN::D1(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -17.1;
}
//---------------------------------------------------------------------------
double AlN::D2(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 7.9;
}
//---------------------------------------------------------------------------
double AlN::D3(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 8.8;
}
//---------------------------------------------------------------------------
double AlN::D4(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -3.9;
}
//------------------------------------------------------------------------------
double AlN::Nc(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double AlN::Nv(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double AlN::ni(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//---------------------------------------------------------------------------
double AlN::n(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
	double carr(0);

	if(iDop == "Si") carr = 6.197e-19*pow(iN*1e-6,1.805)*(3.557e-3*iT*iT - 2.089*iT + 307.57); // Si-doped
	else if(iDop == "Mg") carr = 2e11; //TODO - silna zaleznosc od temperatury !! // Mg-doped
	else carr = 1e12; //undoped

	return (carr*1e6);
}
//---------------------------------------------------------------------------
double AlN::mob(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
	double mob(0);

	if(iDop == "Si")	mob = 29.410*exp(-1.838e-23*n(300.,iN,"Si"))*(10.380 - 1.644*log(iT)); // Si-doped
	else if(iDop == "Mg")	mob = 10.; //TODO - silna zaleznosc od temperatury !! // Mg-doped
	else mob = 30.; //undoped

	return (mob*1e-4);
}
//---------------------------------------------------------------------------
double AlN::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
    double carr(0), //koncentracja nosnikow [1/cm^3]
           tmob(0), //ruchliwosc nosnikow [m^2/Vs]
           delta(0); //wykladnik w zaleznosci temperaturowej [-]
           //sigma(0);

    if(iDop == "Si") { // Si-doped
        carr = n(300.,iN,"Si");
        tmob  = mob(300.,iN,"Si");
        delta = 8.5;
    }
    else if(iDop == "Mg") { // Mg-doped
        carr = n(300.,iN,"Mg");
        tmob  = mob(300.,iN,"Mg");
        delta = 9.8;
    }
    else { // undoped
        carr = n(300.,iN,"u");
        tmob  = mob(300.,iN,"u");
        delta = 8.5;
    }
    return ( cPhys::e * carr * tmob * pow(iT/300.,delta) );
}
//---------------------------------------------------------------------------
double AlN::k(double iT, double /*iN*/, std::string /*iDop*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
    return ( 270.*pow(iT/300.,-1.25) );
}
//---------------------------------------------------------------------------
double AlN::cp(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 0.728e3 );
}
//---------------------------------------------------------------------------
double AlN::g(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 3.258e3 );
}

//------------------------------------------------------------------------------
double AlN::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 164-165";
		ipRef->comment="-";
	}
	return ( 8.5 );
}
//---------------------------------------------------------------------------
double AlN::nR(double /*iLam*/, double /*iT*/, double /*iN*/, std::string /*iDop*/, reference */*ipRef*/)
{
	return 0; // TODO
}
//---------------------------------------------------------------------------
double AlN::abs(double /*iLam*/, double /*iT*/, double /*iN*/, std::string /*iDop*/, reference */*ipRef*/)
{
	return 0; // TODO
}
//---------------------------------------------------------------------------
AlN::AlN(double it)
{
    mt = it; // (um)
}




