#include "pch.h"

#include "AlxOy.h"
//------------------------------------------------------------------------------
double AlxOy::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Le Du , D. Massoubre, J.-C. Harmand and J.-L. Oudar";
		ipRef->title="Thermal conductance of laterally-wet-oxidised GaAs/AlxOy Bragg reflectors";
		ipRef->journal="Electronics Letters, Vol. 42, No. 18, pp. 65-66, 2006.";
		ipRef->comment="-";
	}
	return ( 0.7 ); // [W/(m*K)
}
//------------------------------------------------------------------------------
double AlxOy::nR(double iLam, double iT,reference *ipRef) //[1] uzyskane na podstawie danych z wykresu 5 ( dolna linia)
       // Lambda [nm]
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="T. Kitatani , M. Kondow";
		ipRef->title="Characterization of the Refractive Index of Lateral-Oxidation-Formed AlxOy by Spectroscopic Ellipsometry";
		ipRef->journal="Jpn. J. Appl. Phys., 41, pp. 2954-2957, 2002";
		ipRef->comment="zakres stosowalnosci: 400-1600nm; powyzej 1600nm male zmiany - mozna przyjac wartosc jak dla 1600nm";
	}
	return ( 0.30985*exp(iLam/(-236.72931)) + 1.52829 );
}
//------------------------------------------------------------------------------
double AlxOy::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 10. );
}
//------------------------------------------------------------------------------
AlxOy::AlxOy()
{  
}
//------------------------------------------------------------------------------
AlxOy::~AlxOy()
{
}
//------------------------------------------------------------------------------
