#include "pch.h"

#include "Au.h"
//---------------------------------------------------------------------------
double Au::cte(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J.F. Shackelford, W. Alexander, eds.";
		ipRef->title="CRC Materials Science and Engineering Handbook";
		ipRef->journal="CRC Press Third Edition, 2001";
		ipRef->comment="wartosc dla T = 300 K";
	}
    return ( 14.2e-6 );
}
//---------------------------------------------------------------------------
double Au::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="w pracy podano opornosci elektryczne; oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 1. / er(iT) );
}
//---------------------------------------------------------------------------
double Au::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 8.38e-11*(iT-300.) + 2.279e-8 );
}
//---------------------------------------------------------------------------
double Au::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2298-2299";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
	return ( -0.064*(iT-300.) + 317.1 );
}
//---------------------------------------------------------------------------
double Au::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 0.129e3 );
}
//---------------------------------------------------------------------------
double Au::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 19.32e3 );
}
//---------------------------------------------------------------------------
double Au::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-10um";
	}
	
	int n=6;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.770;	f[1]     = 0.054;	f[2]     = 0.050;	f[3]     = 0.312;	f[4]     = 0.719;	f[5]     = 1.648;
	Gamma[0] = 0.050;	Gamma[1] = 0.074;	Gamma[2] = 0.035;	Gamma[3] = 0.083;	Gamma[4] = 0.125;	Gamma[5] = 0.179;
	w[0]     = 9.03;	w[1]     = 0.218;	w[2]     = 2.885;	w[3]     = 4.069;	w[4]     = 6.137;	w[5]     = 27.97;	
	sigma[0] = 0.000;	sigma[1] = 0.742;	sigma[2] = 0.349;	sigma[3] = 0.830;	sigma[4] = 1.246;	sigma[5] = 1.795;	
	
	return ( cFunc::getOptPar("nR",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
double Au::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-10um";
	}
	
	int n=6;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.770;	f[1]     = 0.054;	f[2]     = 0.050;	f[3]     = 0.312;	f[4]     = 0.719;	f[5]     = 1.648;
	Gamma[0] = 0.050;	Gamma[1] = 0.074;	Gamma[2] = 0.035;	Gamma[3] = 0.083;	Gamma[4] = 0.125;	Gamma[5] = 0.179;
	w[0]     = 9.03;	w[1]     = 0.218;	w[2]     = 2.885;	w[3]     = 4.069;	w[4]     = 6.137;	w[5]     = 27.97;	
	sigma[0] = 0.000;	sigma[1] = 0.742;	sigma[2] = 0.349;	sigma[3] = 0.830;	sigma[4] = 1.246;	sigma[5] = 1.795;	
	
	return ( cFunc::getOptPar("abs",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
Au::Au()
{
}
//---------------------------------------------------------------------------
Au::~Au()
{
}
//---------------------------------------------------------------------------
