#include "pch.h"

#include "AuGe.h"
//------------------------------------------------------------------------------
double AuGe::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="T. Som, P. Ayyub, D. Kabiraj, N. Kulkarni, V.N. Kulkarni and D.K. Avasthi";
		ipRef->title="Formation of Au(0.6)Ge(0.4) alloy induced by Au-ion irradiation of Au/Ge bilayer";
		ipRef->journal="Journal of Applied Physics, vol. 93, no. 2, pp. 903-906, 2003";
		ipRef->comment="wartosc dla stopu zloto-german 60/40; nie podano dla jakiej temperatury";
	}
    return ( 1e8 );
}
//------------------------------------------------------------------------------
double AuGe::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="T. Som, P. Ayyub, D. Kabiraj, N. Kulkarni, V.N. Kulkarni, and D.K. Avasthi";
		ipRef->title="Formation of Au(0.6)Ge(0.4) alloy induced by Au-ion irradiation of Au/Ge bilayer";
		ipRef->journal="Journal of Applied Physics, vol. 93, no. 2, pp. 903-906, 2003";
		ipRef->comment="w pracy podano wartosc przewodnosci elektrycznej dla stopu zloto-german 60/40; nie podano dla jakiej temperatury";
	}
	return ( 1. / ec(iT) );
}
//------------------------------------------------------------------------------
double AuGe::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Applied Thin-Film Products";
		ipRef->title="www.thinfilm.com";
		ipRef->journal="2005";
		ipRef->comment="podano, ze dla stopu zloto-german 88/12: k = 88.34 W/(m*K) dla 273 K";
	}
	return ( 88.34 );
}
//------------------------------------------------------------------------------
AuGe::AuGe()
{
}
//------------------------------------------------------------------------------
AuGe::~AuGe()
{
}
//------------------------------------------------------------------------------
