#include "pch.h"

#include "BCB.h"
//------------------------------------------------------------------------------
double BCB::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 1. / er(iT) );
}
//------------------------------------------------------------------------------
double BCB::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 1e17 );
}
//------------------------------------------------------------------------------
double BCB::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 0.2 );
}
//------------------------------------------------------------------------------
double BCB::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 1176. + 3.37 * iT );
}
//------------------------------------------------------------------------------
double BCB::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 1051. );
}
//------------------------------------------------------------------------------
double BCB::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 2.57 );
}
//---------------------------------------------------------------------------
BCB::BCB()
{  
}
//---------------------------------------------------------------------------
BCB::~BCB()
{
}