#include "pch.h"

#include "Be.h"
//---------------------------------------------------------------------------
/*double Be::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="w pracy podano opornosci elektryczne; oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 1. / er(iT) );
}
//---------------------------------------------------------------------------
double Be::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return (  );
}
//---------------------------------------------------------------------------
double Be::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2298-2299";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
	return (  );
}
//---------------------------------------------------------------------------
double Be::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return (  );
}
//---------------------------------------------------------------------------
double Be::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return (  );
}*/
//---------------------------------------------------------------------------
double Be::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-60um?";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.081;	f[1]     = 0.066;	f[2]     = 0.067;	f[3]     = 0.346;	f[4]     = 0.311;
	Gamma[0] = 0.035;	Gamma[1] = 2.956;	Gamma[2] = 3.962;	Gamma[3] = 2.398;	Gamma[4] = 3.904;
	w[0]     = 18.51;	w[1]     = 0.131;	w[2]     = 0.469;	w[3]     = 2.827;	w[4]     = 4.318;
	sigma[0] = 0.000;	sigma[1] = 0.277;	sigma[2] = 3.167;	sigma[3] = 1.446;	sigma[4] = 0.893;	
	
	return ( cFunc::getOptPar("nR",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
double Be::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-60um?";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.081;	f[1]     = 0.066;	f[2]     = 0.067;	f[3]     = 0.346;	f[4]     = 0.311;
	Gamma[0] = 0.035;	Gamma[1] = 2.956;	Gamma[2] = 3.962;	Gamma[3] = 2.398;	Gamma[4] = 3.904;
	w[0]     = 18.51;	w[1]     = 0.131;	w[2]     = 0.469;	w[3]     = 2.827;	w[4]     = 4.318;
	sigma[0] = 0.000;	sigma[1] = 0.277;	sigma[2] = 3.167;	sigma[3] = 1.446;	sigma[4] = 0.893;	
	
	return ( cFunc::getOptPar("abs",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
Be::Be()
{
}
//---------------------------------------------------------------------------
Be::~Be()
{
}
//---------------------------------------------------------------------------
