#include "pch.h"

#include "Cu.h"
//---------------------------------------------------------------------------
double Cu::cte(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J.F. Shackelford, W. Alexander, eds.";
		ipRef->title="CRC Materials Science and Engineering Handbook";
		ipRef->journal="CRC Press Third Edition, 2001";
		ipRef->comment="wartosc dla T = 300 K";
	}
    return ( 16.5e-6 );
}
//---------------------------------------------------------------------------
double Cu::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="w pracy podano opornosci elektryczne; oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 1. / er(iT) );
}
//---------------------------------------------------------------------------
double Cu::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 6.81e-11*(iT-300.) + 1.726e-8 );
}
//---------------------------------------------------------------------------
double Cu::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2298-2299";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
	return ( 400.8*pow(300./iT,0.073) );
}
//---------------------------------------------------------------------------
double Cu::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 0.384e3 );
}
//---------------------------------------------------------------------------
double Cu::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 8.96e3 );
}
//------------------------------------------------------------------------------
double Cu::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 0.1 );
}
//---------------------------------------------------------------------------
double Cu::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-12.4um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.562;	f[1]     = 0.076;	f[2]     = 0.081;	f[3]     = 0.324;	f[4]     = 0.726;
	Gamma[0] = 0.030;	Gamma[1] = 0.056;	Gamma[2] = 0.047;	Gamma[3] = 0.113;	Gamma[4] = 0.172;
	w[0]     = 10.83;	w[1]     = 0.416;	w[2]     = 2.849;	w[3]     = 4.819;	w[4]     = 8.136;
	sigma[0] = 0.000;	sigma[1] = 0.562;	sigma[2] = 0.469;	sigma[3] = 1.131;	sigma[4] = 1.719;	
	
	return ( cFunc::getOptPar("nR",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
double Cu::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-12.4um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.562;	f[1]     = 0.076;	f[2]     = 0.081;	f[3]     = 0.324;	f[4]     = 0.726;
	Gamma[0] = 0.030;	Gamma[1] = 0.056;	Gamma[2] = 0.047;	Gamma[3] = 0.113;	Gamma[4] = 0.172;
	w[0]     = 10.83;	w[1]     = 0.416;	w[2]     = 2.849;	w[3]     = 4.819;	w[4]     = 8.136;
	sigma[0] = 0.000;	sigma[1] = 0.562;	sigma[2] = 0.469;	sigma[3] = 1.131;	sigma[4] = 1.719;	
	
	return ( cFunc::getOptPar("abs",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
Cu::Cu()
{  
}
//---------------------------------------------------------------------------
Cu::~Cu()
{
}

