#include "pch.h"

#include "GaInNAs.h"
//------------------------------------------------------------------------------
double GaInNAs::a(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	return ( mGa*mAs*mGaAs.a(iT) + mGa*mN*mGaN.a(iT) + mIn*mAs*mInAs.a(iT) + mIn*mN*mInN.a(iT) );
}
//------------------------------------------------------------------------------
double GaInNAs::Eg(double iT, char iPoint, reference *ipRef)
{
	if((ipRef!=NULL)&&(mInt == "lin"))
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	else if( (ipRef!=NULL) && ((mInt == "nlin1")||(mInt == "nlin2")) )
	{
		ipRef->reset();
		ipRef->author="R. Kudrawiec";
		ipRef->title="Parameterization of the band gap energy for GaNxAs1-x-zPz alloys";
		ipRef->journal="Journal of Applied Physics, vol. 101, no. 11, 023522 (?pp.), 2007";
		ipRef->comment="plus nowe dane z: I. Vurgaftman et al., Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
	}
	double tEgLin = mGa*mAs*mGaAs.Eg(iT, iPoint) + mGa*mN*mGaN.Eg(iT, iPoint) + mIn*mAs*mInAs.Eg(iT, iPoint) + mIn*mN*mInN.Eg(iT, iPoint);
	if (mInt == "lin") // interpolacja liniowa
		return ( tEgLin );
	else if ((mInt == "nlin1") || (mInt == "nlin2")) // interpolacja nieliniowa (wyjatek)
	{
		if (iPoint == 'G')
		{
			double tEgGGaNAs = 0.5 * ( /*GaNAs.En()*/1.65 + mGaAs.Eg(iT,iPoint) - sqrt( pow(1.65 - mGaAs.Eg(iT,iPoint),2.) + 4. * /*GaNAs.V()*/2.7 * 2.7 * mN) );
			double tEgGInNAs = 0.5 * ( /*InNAs.En()*/1.44 + mInAs.Eg(iT,iPoint) - sqrt( pow(1.44 - mInAs.Eg(iT,iPoint),2.) + 4. * /*InNAs.V()*/2.0 * 2.0 * mN) );	
			return (mGa*tEgGGaNAs + mIn*tEgGInNAs - mGa*mIn*0.477);
		}
		else return 0.;
	}
	else return 0.;
}
//------------------------------------------------------------------------------
double GaInNAs::Eg(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	return ( Eg(iT, 'G') );
}
//------------------------------------------------------------------------------
double GaInNAs::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tDsoLin = mGa*mAs*mGaAs.Dso() + mGa*mN*mGaN.Dso() + mIn*mAs*mInAs.Dso() + mIn*mN*mInN.Dso();
	if (mInt == "lin") // interpolacja liniowa
		return ( tDsoLin );
	else if (mInt == "nlin1") // interpolacja nieliniowa prosta 
		return ( tDsoLin - mGa*mIn*mAs*0.15 /*- mGa*mIn*mN*0.*/ /*- mGa*mAs*mN*0.*/ /*- mIn*mAs*mN*0.*/ );
	else if (mInt == "nlin2") // interpolacja nieliniowa zlozona 
	{
		double tDsoGaInN = mGa * mGaN.Dso() + mIn * mInN.Dso() /*- mGa * mIn * 0.*/;
		double tDsoGaInAs = mGa * mGaAs.Dso() + mIn * mInAs.Dso() - mGa * mIn * 0.15;
		double tDsoGaNAs = mN * mGaN.Dso() + mAs * mGaAs.Dso() /*- mN * mAs * 0.*/;
		double tDsoInNAs = mN * mInN.Dso() + mAs * mInAs.Dso() /*- mN * mAs * 0.*/;
		return ( (mGa*mIn*(mN*tDsoGaInN+mAs*tDsoGaInAs) + (mN*mAs*(mGa*tDsoGaNAs+mIn*tDsoInNAs))) / (mGa*mIn+mN*mAs) );
	}
	else return 0.;
}
//------------------------------------------------------------------------------
double GaInNAs::me(reference *ipRef)
{
	if((ipRef!=NULL)&&(mInt == "lin"))
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	else if( (ipRef!=NULL) && ((mInt == "nlin1")||(mInt == "nlin2")) )
	{
		ipRef->reset();
		ipRef->author="R.P. Sarzala, L. Piskorski, P. Szczerbiak, R. Kudrawiec, and W. Nakwaski";
		ipRef->title="An attempt to design long-wavelength (>2 um) InP-based GaInNAs diode lasers";
		ipRef->journal="Applied Physics A, vol. 108, no. 3, pp.521-528, 2012";
		ipRef->comment="-";
	}
	double tmeLin = mGa*mAs*mGaAs.me() + mGa*mN*mGaN.me() + mIn*mAs*mInAs.me() + mIn*mN*mInN.me();
	if (mInt == "lin") // interpolacja liniowa
		return ( tmeLin );
	else if ((mInt == "nlin1") || (mInt == "nlin2")) // interpolacja nieliniowa (wyjatek)
		return ( mIn*mAs*mInAs.me() + mGa*mAs*mGaAs.me() - mIn*mGa*0.008 + 0.032);
	else return 0.;
}
//------------------------------------------------------------------------------
double GaInNAs::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tmhhLin = mGa*mAs*mGaAs.mhh() + mGa*mN*mGaN.mhh() + mIn*mAs*mInAs.mhh() + mIn*mN*mInN.mhh();
	return ( tmhhLin ); // lin = nlin1 = nlin2
}
//------------------------------------------------------------------------------
double GaInNAs::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tmlhLin = mGa*mAs*mGaAs.mlh() + mGa*mN*mGaN.mlh() + mIn*mAs*mInAs.mlh() + mIn*mN*mInN.mlh();
	return ( tmlhLin ); // lin = nlin1 = nlin2	
}
//------------------------------------------------------------------------------
double GaInNAs::mso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tmsoLin = mGa*mAs*mGaAs.mso() + mGa*mN*mGaN.mso() + mIn*mAs*mInAs.mso() + mIn*mN*mInN.mso();
	return ( tmsoLin ); // lin = nlin1 = nlin2
}
//------------------------------------------------------------------------------
double GaInNAs::mh(reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3"; 
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double GaInNAs::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN; punktem odniesienia jest Ev=0eV dla InSb";
	}
	double tEvLin = mGa*mAs*mGaAs.Ev() + mGa*mN*mGaN.Ev() + mIn*mAs*mInAs.Ev() + mIn*mN*mInN.Ev();
	if (mInt == "lin") // interpolacja liniowa
		return ( tEvLin );
	else if (mInt == "nlin1") // interpolacja nieliniowa prosta 
		return ( tEvLin - mGa*mIn*mAs*(-0.38) /*- mGa*mIn*mN*0.*/ /*- mGa*mAs*mN*0.*/ /*- mIn*mAs*mN*0.*/ );
	else if (mInt == "nlin2") // interpolacja nieliniowa zlozona 
	{
		double tmeGaInN = mGa * mGaN.me() + mIn * mInN.me() /*- mGa * mIn * 0.*/;
		double tmeGaInAs = mGa * mGaAs.me() + mIn * mInAs.me() - mGa * mIn * (-0.38);
		double tmeGaNAs = mN * mGaN.me() + mAs * mGaAs.me() /*- mN * mAs * 0.*/;
		double tmeInNAs = mN * mInN.me() + mAs * mInAs.me() /*- mN * mAs * 0.*/;
		return ( (mGa*mIn*(mN*tmeGaInN+mAs*tmeGaInAs) + (mN*mAs*(mGa*tmeGaNAs+mIn*tmeInNAs))) / (mGa*mIn+mN*mAs) );
	}
	else return 0.;
}
//------------------------------------------------------------------------------
double GaInNAs::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	return ( Ev() + Eg(iT) );
}
//------------------------------------------------------------------------------
double GaInNAs::ac(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tacLin = mGa*mAs*mGaAs.ac() + mGa*mN*mGaN.ac() + mIn*mAs*mInAs.ac() + mIn*mN*mInN.ac();
	if (mInt == "lin") // interpolacja liniowa
		return ( tacLin );
	else if (mInt == "nlin1") // interpolacja nieliniowa prosta 
		return ( tacLin - mGa*mIn*mAs*2.61 /*- mGa*mIn*mN*0.*/ /*- mGa*mAs*mN*0.*/ /*- mIn*mAs*mN*0.*/ );
	else if (mInt == "nlin2") // interpolacja nieliniowa zlozona 
	{
		double tacGaInN = mGa * mGaN.ac() + mIn * mInN.ac() /*- mGa * mIn * 0.*/;
		double tacGaInAs = mGa * mGaAs.ac() + mIn * mInAs.ac() - mGa * mIn * 2.61;
		double tacGaNAs = mN * mGaN.ac() + mAs * mGaAs.ac() /*- mN * mAs * 0.*/;
		double tacInNAs = mN * mInN.ac() + mAs * mInAs.ac() /*- mN * mAs * 0.*/;
		return ( (mGa*mIn*(mN*tacGaInN+mAs*tacGaInAs) + (mN*mAs*(mGa*tacGaNAs+mIn*tacInNAs))) / (mGa*mIn+mN*mAs) );
	}
	else return 0.;
}
//------------------------------------------------------------------------------
double GaInNAs::av(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tavLin = mGa*mAs*mGaAs.av() + mGa*mN*mGaN.av() + mIn*mAs*mInAs.av() + mIn*mN*mInN.av();
	return ( tavLin ); // lin = nlin1 = nlin2
}
//------------------------------------------------------------------------------
double GaInNAs::b(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tbLin = mGa*mAs*mGaAs.b() + mGa*mN*mGaN.b() + mIn*mAs*mInAs.b() + mIn*mN*mInN.b();
	return ( tbLin ); // lin = nlin1 = nlin2
}
//------------------------------------------------------------------------------
double GaInNAs::d(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tdLin = mGa*mAs*mGaAs.d() + mGa*mN*mGaN.d() + mIn*mAs*mInAs.d() + mIn*mN*mInN.d();
	return ( tdLin ); // lin = nlin1 = nlin2
}
//------------------------------------------------------------------------------
double GaInNAs::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tc11Lin = mGa*mAs*mGaAs.c11() + mGa*mN*mGaN.c11() + mIn*mAs*mInAs.c11() + mIn*mN*mInN.c11();
	return ( tc11Lin ); // lin = nlin1 = nlin2
}
//------------------------------------------------------------------------------
double GaInNAs::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tc12Lin = mGa*mAs*mGaAs.c12() + mGa*mN*mGaN.c12() + mIn*mAs*mInAs.c12() + mIn*mN*mInN.c12();
	return ( tc12Lin ); // lin = nlin1 = nlin2 
}
//------------------------------------------------------------------------------
double GaInNAs::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001"; // plus nowsze wartosci z 2003
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tc44Lin = mGa*mAs*mGaAs.c44() + mGa*mN*mGaN.c44() + mIn*mAs*mInAs.c44() + mIn*mN*mInN.c44();
	return ( tc44Lin ); // lin = nlin1 = nlin2
}
//------------------------------------------------------------------------------
double GaInNAs::Nc(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double GaInNAs::Nv(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double GaInNAs::ni(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//------------------------------------------------------------------------------
double GaInNAs::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment="wartosc interpolowana z danych dla GaAs, GaN, InAs i InN";
	}
	double tgLin = mGa*mAs*mGaAs.g(iT) + mGa*mN*mGaN.g(iT) + mIn*mAs*mInAs.g(iT) + mIn*mN*mInN.g(iT);
	return ( tgLin ); // lin = nlin1 = nlin2
}
//---------------------------------------------------------------------------
void GaInNAs::setInt(std::string iInt)
{
	mInt = iInt;
}
//---------------------------------------------------------------------------
GaInNAs::GaInNAs(double iGa,double iN)
{
	mGa = iGa;
	mIn = 1.-iGa;
	mN = iN;
	mAs = 1.-mN;
	mInt = "nlin1";
}
//---------------------------------------------------------------------------
GaInNAs::GaInNAs()
{  
}
//---------------------------------------------------------------------------
GaInNAs::~GaInNAs()
{
}
