/*##############################################################################
#                                                                              #
# dane materialowe dla GaInNAs                                                 #
#                                                                              #
# data dodania pliku do bazy materialowej: 09-12-2013                          #
# data ostatniej modyfikacji: 17-12-2013                                       #
# autor kodu: LUKASZ PISKORSKI (lukasz.piskorski@p.lodz.pl)                    #
#                                                                              #
##############################################################################*/

#ifndef GaInNAs_h
#define GaInNAs_h

#include "headers.h"
#include "GaAs.h"
#include "GaNzb.h"
#include "InAs.h"
#include "InNzb.h"

class GaInNAs: public material // Ga(x)In(1-x)N(y)As(1-y)
{
	private:
		double mGa, mIn, mN, mAs;
		std::string mInt;
		GaAs mGaAs;
		GaNzb mGaN;
		InAs mInAs;
		InNzb mInN;

	public:
		double a(double iT, reference *ipRef=NULL);    
		double Eg(double iT, char iPoint, reference *ipRef=NULL);
		double Eg(double iT, reference *ipRef=NULL);
		double Dso(reference *ipRef=NULL);
		double me(reference *ipRef=NULL);
		double mhh(reference *ipRef=NULL);
		double mlh(reference *ipRef=NULL);
		double mso(reference *ipRef=NULL);
		double mh(reference *ipRef=NULL);
		double Ev(reference *ipRef=NULL);
		double Ec(double iT, reference *ipRef=NULL);
		double ac(reference *ipRef=NULL);
		double av(reference *ipRef=NULL);
		double b(reference *ipRef=NULL);
		double d(reference *ipRef=NULL);
		double c11(reference *ipRef=NULL);
		double c12(reference *ipRef=NULL);
		double c44(reference *ipRef=NULL);
		double Nc(double iT, reference *ipRef=NULL);
		double Nv(double iT, reference *ipRef=NULL);
		double ni(double iT, reference *ipRef=NULL);
		double g(double iT, reference *ipRef=NULL);
		void setInt(std::string iInt);
		GaInNAs(double iGa, double iN);
		GaInNAs();    
		virtual ~GaInNAs();
};
#endif