#include "pch.h"

#include "GaInNAsSb.h"

double GaInNAsSb::Eg(double T,reference *ref_ptr) // [2]
       //zaleznoc przewry energetycznej GaInNAsSb od temperatury
       //UWAGA na razie tylko dla x=0.38,y=0.023,z=0.027
       {
        //KGUT nieuzywana!! double Eg_300K;
        //KGUT nieuzywana!! double Eg_0K;
        double alpha= 9.13/10000; //[eV/K] wspolczynnik beta do zlaznosci Varshni'ego
        double beta=834; //[K] wspolczynnik beta do zlaznosci Varshni'ego
        
        if ((x==0.38) && (y==0.023) && (z==0.027) )
            {
             //Eg_308K = 0.815;
             double Eg_0K = 0.890841359;
             return Eg_0K - alpha*T*T/(beta+T);// wzynaczenie Eg w 0K na podstwie zaleznosci Varshni'ego
            }
        return 0; // jezeli nie ma w danych zwiazku
        }

double GaInNAsSb::Dso(reference *ref_ptr)
       {return 0.360;}

double GaInNAsSb::me(reference *ref_ptr) //[1]
       {return 0.113;}
       
double GaInNAsSb::mhh(reference *ref_ptr) //[1]
       {return 0.35;}

double GaInNAsSb::mlh(reference *ref_ptr) //[3]
       {return 0.156;}
   

       GaInNAsSb::GaInNAsSb(double x_In,double y_N, double z_Sb)
       {x=x_In;
        y=y_N;
        z=z_Sb;
       }
       GaInNAsSb::GaInNAsSb()
       {}
       GaInNAsSb::~GaInNAsSb()
       {}

/* ref:
[1] L.L. Goddard, S.R. Bank, M.A. Wistey, H.B. Yuen, Z.L. Rao, and J.S. Harris, 
    "Recombination, Gain, Band Structure, Efficiency, and Reliability of 1.5 m GaInNAsSb/GaAs Lasers" ,
    J.Appl.Phys. , vol. 97, no. 8, pp. 83101-83114, 2005      
[2] U. Tisch, E. Finkman, J. Salzman, 
    "The anomalous bandgap bowing in GaAsN", 
    Appl. Phys. Lett., 81, pp. 463-465, 2002
[3] D. Lancefield, A. R. Adams, A. T. Meney, W. Knap, E. Litwin-Staszewska, C. Skierbiszewski, and J. L. Robert, 
    "The light-hole mass in a strained InGaAs/GaAs single quantum well and its pressure dependence", 
    J. Phys. Chem. Solids, 56, pp. 469-473, 1995.

*/
