/*##############################################################################
#                                                                              #
# dane materialowe dla GaInNAsSb                                               #
#                                                                              #
# data dodania pliku do bazy materialowej: 07-12-2005                          #
# data ostatniej modyfikacji: 05-12-2013                                       #
# autor kodu: KRZYSZTOF GUTOWSKI (kgut@o2.pl, kgutek@gmial.com)                #
#                                                                              #
##############################################################################*/

/*Do zrobienia:
               - !! przerwa energetyczna dla dowolnej zawartosci In,N,Sb 
               - wspolczynnik zalamania
               - grupowy wspolczynnik zalamania 
               - zaleznosc wspolczynnika zalamania od temperatury 
               - wspolczynnik absopcji ?
               - publikacje z danymi do przewodnosci elektrycznej ?
               - przewodnosc cieplna
*/
#ifndef GaInNAsSbH
#define GaInNAsSbH

#include <math.h>
#include "material.h"

class GaInNAsSb: public material // Ga(1-x)In(x)N(y)As(1-y-z)Sb(z) 
{
  private:
          double x;// zawartosc In (indu)
          double y;// zawartosc N (azotu)
          double z;// zawartosc Sb (antymonu)
  public:
         double Eg(double,reference *ref_ptr=NULL);
         double Dso(reference *ref_ptr=NULL);
         double me(reference *ref_ptr=NULL);
         double mhh(reference *ref_ptr=NULL);
         double mlh(reference *ref_ptr=NULL);
         GaInNAsSb(double,double,double);
         GaInNAsSb();
         ~GaInNAsSb();

};
#endif
