#include "pch.h"

#include "GaN.h"
//---------------------------------------------------------------------------
double GaN::a(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 3.189;
}
//---------------------------------------------------------------------------
double GaN::c(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 5.185;
}
//---------------------------------------------------------------------------
double GaN::ea(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="http://www.ioffe.ru/SVA/NSM";
		ipRef->comment="-";
	}
	return 4.1;
}
//---------------------------------------------------------------------------
double GaN::Eg(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 24";
		ipRef->comment="-";
	}
	return ( cFunc::Varshni(3.510, 0.914e-3, 825., iT) );
}
//---------------------------------------------------------------------------
double GaN::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 0.017;
}
//---------------------------------------------------------------------------
double GaN::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="-";
	}
	return 0.20;
}
//---------------------------------------------------------------------------
double GaN::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="-";
	}
	return 1.4; // TODO
}
//---------------------------------------------------------------------------
double GaN::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="-";
	}
	return 0.3;
}
//---------------------------------------------------------------------------
double GaN::meL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment=" ";
	}
	return 0.22;
}
//---------------------------------------------------------------------------
double GaN::meT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment=" ";
	}
	return 0.21;
}
//---------------------------------------------------------------------------
double GaN::mhhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A1+A3), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 1.67;
}
//---------------------------------------------------------------------------
double GaN::mhhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A2+A4-A5), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 1.64;
}
//---------------------------------------------------------------------------
double GaN::mlhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A1+A3), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 1.67;
}
//---------------------------------------------------------------------------
double GaN::mlhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A2+A4+A5), wzor z pracy: Phys.Rev.B, 69, 165204, 2004 z uwzgl. APL, 67 (17), 2527-9, 1995";
	}
	return 0.15;
}
//------------------------------------------------------------------------------
double GaN::mh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3";
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double GaN::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Yi-Chia Tsai and Can Bayram";
		ipRef->title="Band Alignments of Ternary Wurtzite and Zincblende III-Nitrides Investigated by Hybrid Density Functional Theory";
		ipRef->journal="ACS Omega 2020, 5, 8, 39173923. https://doi.org/10.1021/acsomega.9b03353";
		ipRef->comment=" ";
	}
	return ( 0.00 );
	/*if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 0.8 );*/
	//return ( -2.64 );
}
//------------------------------------------------------------------------------
double GaN::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( Ev() + Eg(iT) );
}
//---------------------------------------------------------------------------
double GaN::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 390.;
}
//---------------------------------------------------------------------------
double GaN::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 145.;
}
//---------------------------------------------------------------------------
double GaN::c13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 106.;
}
//---------------------------------------------------------------------------
double GaN::c33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 398.;
}
//---------------------------------------------------------------------------
double GaN::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 105.;
}
//---------------------------------------------------------------------------
double GaN::d13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -1.6;
}
//---------------------------------------------------------------------------
double GaN::d15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 3.1;
}
//---------------------------------------------------------------------------
double GaN::d33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 3.1;
}
//---------------------------------------------------------------------------
double GaN::e15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return -0.167;
}
//---------------------------------------------------------------------------
double GaN::e31(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return -0.338;
}
//---------------------------------------------------------------------------
double GaN::e33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return 0.667;
}
//---------------------------------------------------------------------------
double GaN::Psp(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -0.034;
}
//---------------------------------------------------------------------------
double GaN::Dcr(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 0.010;
}
//---------------------------------------------------------------------------
double GaN::D1(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -3.7;
}
//---------------------------------------------------------------------------
double GaN::D2(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 4.5;
}
//---------------------------------------------------------------------------
double GaN::D3(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 8.2;
}
//---------------------------------------------------------------------------
double GaN::D4(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -4.1;
}
//------------------------------------------------------------------------------
double GaN::Nc(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double GaN::Nv(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double GaN::ni(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//---------------------------------------------------------------------------
double GaN::n(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
	double carr(0);

	if(iDop == "Si") carr = 0.55*pow(iN*1e-6,1.01)*(1.217e-3*iT + 0.638); // Si-doped
	//else if(iDop == "Mg")	carr = 6500.*pow(iN*1e-6,0.71)*(2.884e-4*iT*iT - 0.147*iT + 19.144); // Mg-doped
	else if(iDop == "Mg")	carr = 6500.*pow(iN*1e-6,0.71)*(1250.*exp(-2135./iT)); // Mg-doped	//ref: P. Kozodoy, H. Xing, S.P. DenBaars, U.K. Mishra, A. Saxler, R. Perrin, S. Elhamri, W.C. Mitchel, Heavy doping effects in Mg-doped GaN, Journal of Applied Physics, vol. 87, no. 4, pp. 1832-1835, 2000
	else if(iDop == "O")	carr = 4.328e6*pow(iN*1e-6,0.61)*(6.411e-4*iT + 0.808); // O-doped
	else carr = 2e16; // undoped

	return (carr*1e6);
}
//---------------------------------------------------------------------------
double GaN::mob(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
	double mob(0);

	if(iDop == "Si") mob = 4.164e6*pow(n(300.,iN,"Si")*1e-6,-0.228)*(-1.619e-3*iT + 1.486); // Si-doped
	//else if(iDop == "Mg")	mob = 26.7*exp(-n(300.,iN,"Mg")*1e-24)*(2.495e-5*iT*iT - 2.268e-2*iT + 5.557); // Mg-doped
	else if(iDop == "Mg")	mob = 26.7*exp(-n(300.,iN,"Mg")*1e-24)*(54000.*pow(iT,-1.91)); // Mg-doped	//ref: P. Kozodoy, H. Xing, S.P. DenBaars, U.K. Mishra, A. Saxler, R. Perrin, S. Elhamri, W.C. Mitchel, Heavy doping effects in Mg-doped GaN, Journal of Applied Physics, vol. 87, no. 4, pp. 1832-1835, 2000
	else if(iDop == "O")	mob = 3.066e9*pow(n(300.,iN,"O")*1e-6,-0.398)*(2.030e-5*iT*iT - 1.850e-2*iT + 4.722); // O-doped
	else mob = 800; //undoped

	return (mob*1e-4);
}
//---------------------------------------------------------------------------
double GaN::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
    double carr(0), // koncentracja nosnikow [1/cm^3]
           tmob(0), // ruchliwosc nosnikow [m^2/Vs]
           delta(0);//, // wykladnik w zaleznosci temperaturowej [-]
           //sigma(0);

    // undoped GaN
    carr = 2e22;
    tmob = 800e-4;
    delta = -0.2;

    if(iDop == "Si") { // Si-doped
        carr = n(300.,iN,"Si");
        tmob  = mob(300.,iN,"Si");
        delta = -0.2;
    }
    /*else if(iDop == "Mg") { // Mg-doped
        carr = n(300.,iN,"Mg");
        tmob  = mob(300.,iN,"Mg");
        delta = 4.25;
    }*/
	else if(iDop == "O") { // O-doped
        carr = n(300.,iN,"O");
        tmob  = mob(300.,iN,"O");
        delta = -1.8;
    }
	else { // undoped
        carr = n(300.,iN,"u");
        tmob  = mob(300.,iN,"u");
        delta = -0.2;
	}

	if(iDop == "Mg") // Mg-doped
		return ( cPhys::e * n(iT,iN,"Mg") * mob(iT,iN,"Mg") );
    else
		return ( cPhys::e * carr * tmob * pow(iT/300.,delta) );
}
//---------------------------------------------------------------------------
double GaN::k(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
    double k(0);

	// undoped GaN
	if(mt) k = 230.*pow(tanh(0.001529*pow(mt,0.984)),0.12);
	else k = 230.;

    if(iDop == "Si") k = k*exp(-4.67*iN*1e-27); // Si-doped
    if(iDop == "Mg") k = k*exp(-3.63*iN*1e-27); // Mg-doped

    k = k*pow(iT/300.,-1.4);
    return k;
}
//---------------------------------------------------------------------------
double GaN::cp(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 0.42e3 );
}
//---------------------------------------------------------------------------
double GaN::g(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 6.0865e3 );
}

//------------------------------------------------------------------------------
double GaN::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 164-165";
		ipRef->comment="-";
	}
	return ( 10.4 );
}
//---------------------------------------------------------------------------
double GaN::nR(double iLam, double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podstawie danych eksperymentalnych z roznych prac";
	}

	double tE = cPhys::h_eVc1e9 / iLam;

    double nR = 0.;
    if (tE <= 1.5)
    {
        tE = 1.5;
        nR = 0.013914*tE*tE*tE*tE - 0.096422*tE*tE*tE + 0.27318*tE*tE - 0.27725*tE + 2.3535; /// wczesniej bylo, ze nR = 0
    }
    else if (tE <= 2.135872)
        nR = 0.013914*tE*tE*tE*tE - 0.096422*tE*tE*tE + 0.27318*tE*tE - 0.27725*tE + 2.3535;
    else if (tE <= 3.163507)
        nR = 0.1152*tE*tE*tE - 0.7955*tE*tE + 1.959*tE + 0.68;
    else if (tE <= 3.357226)
        nR = 18.2292*tE*tE*tE - 174.6974*tE*tE + 558.535*tE - 593.164;
    else if (tE <= 3.469242)
        nR = 33.63905*tE*tE*tE - 353.1446*tE*tE + 1235.0168*tE - 1436.09;
    else if (tE <= 3.680144)
        nR = -0.72116*tE*tE*tE + 8.8092*tE*tE - 35.8878*tE + 51.335;
    else if (tE < 4.5)
        nR = 0.351664*tE*tE*tE*tE - 6.06337*tE*tE*tE + 39.2317*tE*tE - 112.865*tE + 124.358;
    else
    {
        tE = 4.5;
        nR = 0.351664*tE*tE*tE*tE - 6.06337*tE*tE*tE + 39.2317*tE*tE - 112.865*tE + 124.358; /// wczesniej bylo, ze nR = 0
    }

    ///double d = 42470. * pow(iLam,-3) - 159.2 * pow(iLam,-2) + 0.2187 * pow(iLam,-1) - 0.00003427;

	///double nR_undoped = nR * pow((iT/300.), d); /// zmiana 30.03.2018

	double nR_undoped = nR;
	double nR_doped = 0.;

	if ((iDop == "Si" || iDop == "O"))
	{
        double tau = 1e-14; //[s]
        double m = me() * cPhys::m0; //[kg]
        double pic2 = 2. * cMath::pi * cPhys::c;
        ////double eps = nR_undoped * nR_undoped;
        ///double n_ = n(iT,iN,iDop); /// zmiana 30.03.2018
        double n_ = n(300.,iN,iDop); /// zmiana 30.03.2018
        //std::cout<< "n_: " << n_ << "\n";
        double omegaP2 = n_ * (cPhys::e)*(cPhys::e) / (m*cPhys::epsilon0);
        double omega = pic2 / (iLam*1e-9);
        double omega2 = omega*omega;
        double deps = (1.-omegaP2/(omega2+1./(tau*tau)));
        double dnR = 100.*(1.-sqrt(deps));
        nR_doped = (nR_undoped-dnR*nR_undoped/100.);
        //std::cout<< "nR_doped: " << nR_doped << "\n";
	}
	else if (iDop == "Mg")
	{
        double tau = 1e-14; //[s]
        double m = mh() * cPhys::m0; //[kg]
        double pic2 = 2. * cMath::pi * cPhys::c;
        ////double eps = nR_undoped * nR_undoped;
        //double n_ = n(iT,iN,iDop);
        double n_ = iN;
        double omegaP2 = n_ * (cPhys::e)*(cPhys::e) / (m*cPhys::epsilon0);
        double omega = pic2 / (iLam*1e-9);
        double omega2 = omega*omega;
        double deps = (1.-omegaP2/(omega2+1./(tau*tau)));
        double dnR = 100.*(1.-sqrt(deps));
        nR_doped = (nR_undoped-dnR*nR_undoped/100.);
	}
    else // czyli takze i dla p-GaN
        nR_doped = nR_undoped;

    double _dnRdT = 42470. * pow(iLam,-3) - 159.2 * pow(iLam,-2) + 0.2187 * pow(iLam,-1) - 0.00003427;
    return ( nR_doped + _dnRdT * (iT - 300.) );
}
//---------------------------------------------------------------------------
double GaN::abs(double iLam, double iT, double iN, std::string iDop, reference */*ipRef*/)
{
	double dE = cPhys::h_eVc1e9/iLam - Eg(iT); // dE = E - Eg
	if ((iDop == "Si" || iDop == "O"))
	{
        double n_ = (n(iT,iN,iDop)) * 1e-24;
        if (n_ < 1.)
            n_ = 1.;
        double c1 = -18985. * pow(n_, -1.00021); // dopasowanie (P) do danych z R. Kucharski, Transparency of Semi-Insulating, n-Type, and p-Type ..., Crystals 2017, 7, 187
        double c2 = (0.40952-7.19e-3*n_+1.30887e-4*n_*n_) * pow(n_, -0.79); // dopasowanie (P) do danych z R. Kucharski, Transparency of Semi-Insulating, n-Type, and p-Type ..., Crystals 2017, 7, 187
        return ( (19000.+c1*n_) * exp(dE/(0.019+c2*n_)) + (330.+0.001*n_) * exp(dE/(0.07+0.0005*n_)) ); // postac wzoru z Piprek et al., SPIE 6766 (2007) 67660H
        /*
        double nR_undoped = nR(iLam, iT, iN, iDop);

        double tau = 1e-14; //[s]
        double m = me() * cPhys::m0; //[kg]
        double pic2 = 2. * cMath::pi * cPhys::c;
        double eps = 2. * nR_undoped;
        double n_ = n(iT,iN,iDop);
        double omegaP2 = n_ * (cPhys::e)*(cPhys::e) / (m*cPhys::epsilon0);
        double omega = pic2 / (iLam*1e-9);
        double omega2 = omega*omega;

        double k = (omegaP2/(omega*tau*(omega2+1./(tau*tau))));
        double absp = 10000.*4.*cMath::pi*k/(iLam/1000.);
        return absp;*/
	}
	else
    {
        double P = iN * 1e-24;
        return ( (19000.+200.*P) * exp(dE/(0.019+0.0001*P)) + (330.+30.*P) * exp(dE/(0.07+0.0008*P)) ); //Piprek et al., SPIE 6766 (2007) 67660H
    }
}
//---------------------------------------------------------------------------
GaN::GaN(double it)
{
	mt = it; // (um)
}






