#include "pch.h"

#include "GaNAs.h"
using namespace std;

double GaNAs::Eg(double T,reference *ref_ptr) // [2]
       {
        if(ref_ptr!=NULL)
          {ref_ptr->reset();
           ref_ptr->author="U. Tisch, E. Finkman, J. Salzman";
           ref_ptr->title="The anomalous bandgap bowing in GaAsN";
           ref_ptr->journal="Appl. Phys. Lett., 81, pp. 463-465, 2002";
          }
        double b =7.5 + 21.1*::exp(- x/0.0026) + 15.9*::exp(- x/0.033);
        double Eg_300K = 1.41*(1 - x) + 3.2*x - b*x*(1 - x);  // wyzanczenie przerwy energetycznej w 300k na podstawie zawartosci azotu
        double alpha= 1.0*6.1/10000; //[eV/K] wspolczynnik beta do zlaznosci Varshni'ego
        double beta=560; //[K] wspolczynnik beta do zlaznosci Varshni'ego
        double T_300=300;// temperatura 300K
        double Eg_0K = Eg_300K + (double)alpha*T_300*T_300/(double)(beta+T_300);// wzynaczenie Eg w 0K na podstwie zaleznosci Varshni'ego
        return (Eg_0K - alpha*T*T/(beta+T)); //Eg w temp. T zaleznosc Varshni'ego
        
       }

double GaNAs::me(reference *ref_ptr) //[1]
       {if(ref_ptr!=NULL)
          {ref_ptr->reset();
           ref_ptr->author="L.L. Goddard, S.R. Bank, M.A. Wistey, H.B. Yuen, Z.L. Rao, and J.S. Harris";
           ref_ptr->title="Recombination, Gain, Band Structure, Efficiency, and Reliability of 1.5 m GaInNAsSb/GaAs Lasers";
           ref_ptr->journal="J.Appl.Phys. , vol. 97, no. 8, pp. 83101-83114, 2005";
          }
        return 0.072;}
       
double GaNAs::mhh(reference *ref_ptr) //[1]
       {if(ref_ptr!=NULL)
          {ref_ptr->reset();
           ref_ptr->author="L.L. Goddard, S.R. Bank, M.A. Wistey, H.B. Yuen, Z.L. Rao, and J.S. Harris";
           ref_ptr->title="Recombination, Gain, Band Structure, Efficiency, and Reliability of 1.5 m GaInNAsSb/GaAs Lasers";
           ref_ptr->journal="J.Appl.Phys. , vol. 97, no. 8, pp. 83101-83114, 2005";
          }
        return 0.355;}

double GaNAs::mlh(reference *ref_ptr) //[3]
       {if(ref_ptr!=NULL)
          {ref_ptr->reset();
           ref_ptr->author="I. Vurgaftman and J. R. Meyer";
           ref_ptr->title="Band parameters for III-V compound semiconductors and their alloys";
           ref_ptr->journal="J. Appl. Phys., 89, pp. 5815-5875, 2001";
          }
        return 0.081;}

double GaNAs::nR(double iLam, double iT, reference * ref_ptr)//[nm]
       {if(ref_ptr!=NULL)
          {ref_ptr->reset();
           ref_ptr->author="--";
           ref_ptr->title="--";
           ref_ptr->journal="--";
           ref_ptr->comment="interpolacja z GaN i GaAs";
          }
       
       //KGUT nieuzywana!! material *GaAs = new AlGaAs(0); // utworzenie materialu GaAs potrzebnego do interpolacji wspolczynika zalamania 
       
       double y0=2.27616;
       double A=9.63785;
       double t=-109.58461;
       
       double GaN_refraction_index = y0+A*::exp(x/t);
       //KGUT nieuzywana!! double Mod=-1.03655;
	   return GaN_refraction_index;
       }

       GaNAs::GaNAs(double x_N)
       {x=x_N;
       }
       GaNAs::GaNAs()
       {}
       GaNAs::~GaNAs()
       {}

/* ref:
[1] L.L. Goddard, S.R. Bank, M.A. Wistey, H.B. Yuen, Z.L. Rao, and J.S. Harris, 
    "Recombination, Gain, Band Structure, Efficiency, and Reliability of 1.5 m GaInNAsSb/GaAs Lasers" ,
    J.Appl.Phys. , vol. 97, no. 8, pp. 83101-83114, 2005      
[2] U. Tisch, E. Finkman, J. Salzman, "The anomalous bandgap bowing in GaAsN", 
    Appl. Phys. Lett., 81, pp. 463-465, 2002
[3] I. Vurgaftman and J. R. Meyer, 
    "Band parameters for III-V compound semiconductors and their alloys", 
    J. Appl. Phys., 89, pp. 5815-5875, 2001.
*/
