/*##############################################################################
#                                                                              #
# dane materialowe dla GaInNAsSb                                               #
#                                                                              #
# data dodania pliku do bazy materialowej: 07-12-2005                          #
# data ostatniej modyfikacji: 05-12-2013                                       #
# autor kodu: KRZYSZTOF GUTOWSKI (kgut@o2.pl, kgutek@gmial.com)                #
#                                                                              #
##############################################################################*/

/*Do zrobienia:
               - wspolczynnik zalamania (poszukac lepszych danych)
               - grupowy wspolczynnik zalamania 
               - zaleznosc wspolczynnika zalamania od temperatury 
               - wspolczynnik absopcji ?
               - publikacje z danymi do przewodnosci elektrycznej ?
               - przewodnosc cieplna
*/
#ifndef GaNAsH
#define GaNAsH

#include <math.h>
#include "material.h"
#include "AlGaAs.h"  //uzywane do interpolacji wspolczynnika zalamania

class GaNAs: public material // GaN(x)As(1-x) oksydacja
{
  private:
          double x;// zawartosc azotu
  public:
         double Eg(double,reference *ref_ptr=NULL);
         double me(reference *ref_ptr=NULL);
         double mhh(reference *ref_ptr=NULL);
         double mlh(reference *ref_ptr=NULL);
         double nR(double iLam, double iT, reference * ref_ptr=NULL);//[nm]
         GaNAs(double);
         GaNAs();
         ~GaNAs();

};
#endif
