#include "pch.h"

#include "GaSb.h"
//------------------------------------------------------------------------------
double GaSb::a(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( 6.0959+4.72e-5*(iT-300.) );
}
//------------------------------------------------------------------------------
double GaSb::Eg(double iT, char iPoint, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	if (iPoint == 'G') return ( cFunc::Varshni(0.812, 0.417e-3, 140., iT) );
	else if (iPoint == 'X') return ( cFunc::Varshni(1.141, 0.475e-3, 94., iT) );
	else if (iPoint == 'L') return ( cFunc::Varshni(0.875, 0.597e-3, 140., iT) );
	else return 0.;
}
//------------------------------------------------------------------------------
double GaSb::Eg(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( Eg(iT, 'G') );
}
//------------------------------------------------------------------------------
double GaSb::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( 0.76 );
}
//------------------------------------------------------------------------------
double GaSb::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 0.039 );
}
//------------------------------------------------------------------------------
double GaSb::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 0.22 );
}
//------------------------------------------------------------------------------
double GaSb::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 0.045 );
}
//------------------------------------------------------------------------------
double GaSb::mso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( 0.12 );
}
//------------------------------------------------------------------------------
double GaSb::mh(reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3"; 
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double GaSb::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="punktem odniesienia jest Ev=0eV dla InSb";
	}
	return ( -0.03 );
}
//------------------------------------------------------------------------------
double GaSb::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( Ev() + Eg(iT) );
}
//------------------------------------------------------------------------------
double GaSb::ac(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( -7.5 );
}
//------------------------------------------------------------------------------
double GaSb::av(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( -0.8 );
}
//------------------------------------------------------------------------------
double GaSb::b(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( -2.0 );
}
//------------------------------------------------------------------------------
double GaSb::d(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( -4.7 );
}
//------------------------------------------------------------------------------
double GaSb::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( 88.42 );
}
//------------------------------------------------------------------------------
double GaSb::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( 40.26 );
}
//------------------------------------------------------------------------------
double GaSb::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( 43.22 );
}
//------------------------------------------------------------------------------
double GaSb::Nc(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double GaSb::Nv(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double GaSb::ni(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//------------------------------------------------------------------------------
double GaSb::n(double iT, double iN, std::string iDop, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Lukasz Piskorski";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podstawie danych eksperymentalnych z roznych prac"; 
	}
	if (iDop == "Se")
	{
		if (iN <= 1.2e24)
			return ( 0.66*iN ); // (dopasowanie do danych eksp.: Lukasz)
		else
			return ( 8e23 ); // (dopasowanie do danych eksp.: Lukasz)
	}
	else if (iDop == "Te") // Chiu (1990) Te doping (APL)
	{
		if (iN <= 1e24)
			return iN;
		else
		{
			double tN = iN*1e-6; // m^-3 -> cm^-3 
			double tNL = log10(tN);
			double tnL = 0.499626*tNL*tNL*tNL - 28.7231*tNL*tNL + 549.517*tNL - 3480.87;
			return ( pow(10.,tnL)*1e6 );
		}
	}
	else if (iDop == "Si") // nasi TODO
	{
		if (iN <= pow(10.,((1.-2.27)/(-0.0731))) * 1e6) 
			return ( iN ); // (dopasowanie do danych eksp.: Lukasz)
		else
			return ( (-0.0731*log10(iN*1e-6)+2.27) * iN ); // (dopasowanie do danych eksp.: Lukasz)
	}
	else		
		return iN; // TODO
}
//------------------------------------------------------------------------------
double GaSb::mob(double iT, double iN, std::string iDop, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Martin";
		ipRef->title="-";
		ipRef->journal="2004";
		ipRef->comment="-"; 
	}
	/*if ( (iDop == "Se") || (iDop == "Te") )
		return ( 1050e-4 + (5650e-4*pow(300./iT,2.0)-1050e-4) / (1.+pow(iN/(2.8e17*pow(iT/300.,2.8)),1.05)) );
	else if (iDop == "Si")
		return ( 190e-4 + (875e-4*pow(300./iT,1.7)-190e-4) / (1.+pow(iN/(9e17*pow(iT/300.,2.7)),0.65)) );*/
	if (iDop == "Te")
	{
		double tGaSb_miRT = 4260e-4/(1.+pow(n(300., iN, iDop)/8e23,1.25)); // (m^2/(V*s)) (dopasowanie do danych eksp.: Lukasz)
		return ( tGaSb_miRT * pow(300./iT,0.8) ); // (1.5 -> zalozenie)		
	}
	else if (iDop == "Se") // TODO
		return ( 1050e-4 + (5650e-4*pow(300./iT,2.0)-1050e-4) / (1.+pow(iN/(2.8e17*pow(iT/300.,2.8)),1.05)) );
	else if (iDop == "Si") // TODO
		return ( 190e-4 + (875e-4*pow(300./iT,1.7)-190e-4) / (1.+pow(iN/(9e17*pow(iT/300.,2.7)),0.65)) );
	else
		return 0.;
}
//------------------------------------------------------------------------------
double GaSb::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	double tec300 = cPhys::e * mob(300., iN, iDop) * n(300., iN, iDop);
	return ( tec300*pow(300./iT,1.5) );       
}
//------------------------------------------------------------------------------
double GaSb::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	} 
	return ( 36.*pow(300./iT,1.35) );
}
//---------------------------------------------------------------------------
double GaSb::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 0.344e3 );
}
//---------------------------------------------------------------------------
double GaSb::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 5.61461e3 );
}

//------------------------------------------------------------------------------
double GaSb::nR(double iLam, double iT, double iN, std::string iDop, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Munoz-Uribe, C.E.M. de Oliveira, J.H. Clerice, R.S. Miranda, M.B. Zakia, M.M.G. de Carvalho, and N.B. Patel";
		ipRef->title="Measurement of refractive index of GaSb (1.8 to 2.56 um) using a prism";
		ipRef->journal="Electronics Letters, vol. 32, no. 3, pp. 262-264, 1996";
		ipRef->comment="zaleznosc poprawna dla przedzialu 1800-2560 nm";
	}
	double tN = n(300., iN, iDop);
	double tLam2 = 1e-6*iLam*iLam; // 1e-3: nm-> um
	double tnR300K = sqrt(1.+13.05*tLam2/(tLam2-0.32)); // (dopasowanie do danych eksp.: Lukasz)
	if ( (iDop == "Se") || (iDop == "Te") )
		tnR300K -= 0.034*(tN*1e-24); // -3.4e-2 -> dopasowanie do danych eksp.: Lukasz (na podstawie pracy: P.P. Paskov (1997) J. Appl. Phys. 81, 1890-1898)
	else if (iDop == "Si")
		tnR300K -= 0.0079*(tN*1e-24); // -7.9e-3 -> dopasowanie do danych eksp.: Lukasz (na podstawie pracy: P.P. Paskov (1997) J. Appl. Phys. 81, 1890-1898)
	if (iLam >= 1800.) // 1.8-2.56 um
        return ( tnR300K + tnR300K*8.2e-5*(iT-300.) ); // 8.2e-5 -> Adachi (2005) ebook p.243 tab. 10.6
    else
        return 0.;
}
//------------------------------------------------------------------------------
double GaSb::abs(double iLam, double iT, double iN, std::string iDop, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A. Chandola, R. Pino, and P.S. Dutta";
		ipRef->title="Below bandgap optical absorption in tellurium-doped GaSb";
		ipRef->journal="Semiconductor Science and Technology, vol. 20, no. 8, pp. 886-893. 2005";
		ipRef->comment="zaleznosc poprawna dla przedzialu 2-20 um";
	}
	if (iDop == "Te")
	{
		/*double tN = iN*1e-24;
		double tLam = iLam*1e-3;
		double tFCabs = 2.42*tN*pow(tLam,2.16-0.22*tN); // (dopasowanie do danych: Lukasz)
		double tIVCBabs = (24.1*tN+12.5)*(1.24/tLam-(0.094*tN+0.12))+(-2.05*tN-0.37); // (dopasowanie do danych: Lukasz)
		if (tIVCBabs>0) return ( tFCabs + tIVCBabs );
		else return ( tFCabs );*/
		double tN_ = n(300., iN, iDop);
		double tN = tN_*1e-24;			// LUKASZ 01.10.2014
		double tLam = iLam*1e-3;
		double tFCabs = (2.3*pow(tN,1.3))*pow(tLam,2.); // (dopasowanie do danych: Lukasz)
		double tIVCBabs = (38.6*pow(tN,0.48)) * (cPhys::h_eVc1e9*1e-3/iLam - 0.225*pow(tN,0.28)) - 2.5*pow(tN,0.68); // (dopasowanie do danych: Lukasz)
		if (tIVCBabs>0) return ( tFCabs + tIVCBabs );
		else return ( tFCabs );
	}
	else if (iDop == "Si") // dopisac zrodla TODO
	{
		double tN_ = n(300., iN, iDop);
		double tP = tN_*1e-24;			// LUKASZ 02.10.2014
		double tLam = iLam*1e-3;
		double tFCabs = (42600*pow(tP,0.17))*pow(tLam,1.8); // (dopasowanie do danych: Lukasz)
		return ( tFCabs );
	}
	else
		return 0.;
}
//------------------------------------------------------------------------------
GaSb::GaSb()
{
}
//------------------------------------------------------------------------------
GaSb::~GaSb()
{
}
//------------------------------------------------------------------------------
