#include "pch.h"

#include "Ge.h"
//---------------------------------------------------------------------------
double Ge::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="C. J. Glassbrenner and Glen A. Slack";
		ipRef->title="Thermal Conductivity of Silicon and Germanium from 3K to the Melting Point, <https://journals.aps.org/pr/abstract/10.1103/PhysRev.134.A1058>";
		ipRef->journal="Phys. Rev. 134, A1058  Published 18 May 1964";
		ipRef->comment="wzor podany w pracy";
	}
	return ( 100/(3.95e-3 * iT + 3.38e-6 * iT * iT + 0.17));
}
//---------------------------------------------------------------------------
double Ge::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		//ipRef->reset();
		//ipRef->author="David R. Lide, ed.";
		//ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		//ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		//ipRef->comment="wartosc dla 25C";
	}
	return ( 0.31e3 );
}
//---------------------------------------------------------------------------
double Ge::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		//ipRef->reset();
		//ipRef->author="David R. Lide, ed.";
		//ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		//ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		//ipRef->comment="wartosc dla 25C";
	}
	return ( 5.32e3 );
}
//---------------------------------------------------------------------------
Ge::Ge()
{ 
}
//---------------------------------------------------------------------------
Ge::~Ge()
{
}