#include "pch.h"

#include "HfO2.h"
//------------------------------------------------------------------------------
double HfO2::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S.-M. Lee and David G. Cahill";
		ipRef->title="Thermal conductivity of sputtered oxide films";
		ipRef->journal="PHYSICAL REVIEW B, VOLUME 52, NUMBER 1 p.253 (1995)";
		ipRef->comment="podano przyblizona wartosc dla cinkich napylanych warstw";
	}
	return ( 1.1 );
}
//------------------------------------------------------------------------------
double HfO2::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="podano rzad wielkosci";
	}
	return ( 1e-7 );
}
//------------------------------------------------------------------------------
double HfO2::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. F. Al-Kuhaili, 2004";
		ipRef->title="Optical properties of hafnium oxide thin films and their application ...";
		ipRef->journal="Opt. Mat. 27, 383-387 (2004)";
		ipRef->comment="zakres stosowalnosci: 200nm-2um";
	}
	if (iLam<200.) iLam = 200.;
	else if (iLam>2000.) iLam = 2000.;
	iLam *= 1e-3;	//przejscie na um
	
	return (1.875 + 6.28e-3 * pow(iLam, -2) + 5.80e-4 * pow(iLam, -4));
}
//------------------------------------------------------------------------------
double HfO2::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="brak danych";
		ipRef->title="brak danych";
		ipRef->journal="brak danych";
		ipRef->comment="brak danych - spotykane bardzo rozne wartosci";
	}
	
	return ( 0.0) ;
}
//---------------------------------------------------------------------------
double HfO2::cp(double iT, reference* ipRef)
{
	if (ipRef != NULL)
	{
		ipRef->reset();
		ipRef->author = "-";
		ipRef->title="https://www.attelements.com/hafnium-metals-and-alloys/hafnium-oxide,-hfo2.html";
		ipRef->journal="https://www.makeitfrom.com/material-properties/Hafnia-Hafnium-Oxide-HfO2";
		ipRef->comment="dane z sieci dla cp, ale takze k i g";
	}
	return (0.12e3);
}
//---------------------------------------------------------------------------
double HfO2::g(double iT, reference* ipRef)
{
	if (ipRef != NULL)
	{
		ipRef->reset();
		ipRef->author = "Jinfu Lin, Hongxia Liu, Shulong Wang and Siyu Zhang";
		ipRef->title="Modeling and Simulation of Hafnium Oxide ...";
		ipRef->journal="Crystals 2021, 11, 1462. https://doi.org/10.3390/cryst11121462";
		ipRef->comment="brak wyjasnienia - jednak sa mozliwe - porownaj z g";
	}
	return (9.7e3);
}
HfO2::HfO2()
{
}
//---------------------------------------------------------------------------
HfO2::~HfO2()
{
}


