#include "pch.h"

#include "ITO.h"
//------------------------------------------------------------------------------
double ITO::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Takashi Yagi, Kimiaki Tamano, Yasushi Sato, Naoyuki Taketoshi, Tetsuya Baba, and Yuzo Shigesato";
		ipRef->title="Analysis on thermal properties of tin doped indium oxide films by picosecond thermoreflectance measurement";
		ipRef->journal="J. Vac. Sci. Technol. A, vol. 23, no. 4, pp.1180-1186, 2005";
		ipRef->comment="dla materialu bulk wartosc moze wynosic 10-14 W/(m*K)";
	}
	return ( 3.2 );
}
//------------------------------------------------------------------------------
double ITO::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Ocal Tuna, Yusuf Selamet, Gulnur Aygun, and Lutfi Ozyuzer";
		ipRef->title="High quality ITO thin films grown by dc and RF sputtering without oxygen";
		ipRef->journal="J. Phys. D: Appl. Phys., vol. 43, 055402 (7pp), 2010";
		ipRef->comment="podano rzad wielkosci";
	}
	return ( 1e6 );
}
//------------------------------------------------------------------------------
double ITO::nR(double iLam, double iT, reference *ipRef)
{
	//stara zaleznosc
	/*
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="E. F. Schubert, 2004";
		ipRef->title="Refractive index and extinction coefficient of materials";
		ipRef->journal="Most data after Filmetrics Corporation of San Diego, California (2002)";
		ipRef->comment="zakres stosowalnosci: 300-600nm";
	}
	if (iLam<300.) iLam = 300.;
	else if (iLam>600.) iLam = 600.;
	double a0 = 60.509437902406;
	double a1 = -0.718250086032;
	double a2 = 0.003694636502;
	double a3 = -1.013137422769e-5;
	double a4 = 1.557549876091e-8;
	double a5 = -1.271266350715e-11;
	double a6 = 4.300324516122e-15;
	return ( a0 + a1*iLam + a2*pow(iLam,2.) + a3*pow(iLam,3.) + a4*pow(iLam,4.) + a5*pow(iLam,5.) + a6*pow(iLam,6.) );
	*/

	//nowa zaleznosc RPS 23.08.2017
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="T. A. F. Konig, P. A. Ledin, ... and V. V. Tsukruk";
		ipRef->title="Electrically tunable plasmonic behavior of ... electrochromic polymer";
		ipRef->journal="Nano VOL. 8, NO. 6, 61826192 (2014) - Numerical data provided by Tobias Konig";
		ipRef->comment="zakres stosowalnosci: 350-550nm - refractive.index.info";
	}
	if (iLam<350.) iLam = 350.;
	else if (iLam>550.) iLam = 550.;
	double a0 = 4.640919531932;
	double a1 = -0.01416386726;
	double a2 = 2.595910501739E-5;
	double a3 = -1.707668581006E-8;
	return ( a0 + a1*iLam + a2*pow(iLam,2.) + a3*pow(iLam,3.) );
}
//------------------------------------------------------------------------------
double ITO::abs(double iLam, double iT, reference *ipRef)
{
	//stara zaleznosc
	/*
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="E. F. Schubert, 2004";
		ipRef->title="Refractive index and extinction coefficient of materials";
		ipRef->journal="Most data after Filmetrics Corporation of San Diego, California (2002)";
		ipRef->comment="zakres stosowalnosci: 320-590nm";
	}
	if (iLam<320.) iLam = 320.;
	else if (iLam>590.) iLam = 590.;
	double a0 = 7.113494587405e7;
	double a1 = -1.247360184765e6;
	double a2 = 9542.769179929042;
	double a3 = -41.565762939927;
	double a4 = 0.112683932339;
	double a5 = -1.946265124542e-4;
	double a6 = 2.091021635437e-7;
	double a7 = -1.277479308254e-10;
	double a8 = 3.397599939864e-14;
    return ( a0 + a1*iLam + a2*pow(iLam,2.) + a3*pow(iLam,3.) + a4*pow(iLam,4.) + a5*pow(iLam,5.) + a6*pow(iLam,6.) + a7*pow(iLam,7.) + a8*pow(iLam,8.) );
	*/

	//nowa zaleznosc RPS 23.08.2017
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="T. A. F. Konig, P. A. Ledin, ... and V. V. Tsukruk";
		ipRef->title="Electrically tunable plasmonic behavior of ... electrochromic polymer";
		ipRef->journal="Nano VOL. 8, NO. 6, 61826192 (2014) - Numerical data provided by Tobias Konig";
		ipRef->comment="zakres stosowalnosci: 350-550nm - refractive.index.info";
	}
	if (iLam<350.) iLam = 350.;
	else if (iLam>550.) iLam = 550.;
	double y0 = 630.9358;
	double A1 = 9451484.86748;
	double t1 = 49.21757;
    return ( y0 + A1*exp(-iLam/t1) );
} 
//---------------------------------------------------------------------------
ITO::ITO()
{
}
//---------------------------------------------------------------------------
ITO::~ITO()
{
}


