#include "pch.h"

#include "In.h"
//---------------------------------------------------------------------------
double In::cte(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="http://en.wikipedia.org/wiki/Indium";
		ipRef->comment="wartosc dla T = 300 K";
	}
    return ( 32.1e-6 );
}
//---------------------------------------------------------------------------
double In::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Applied Thin-Film Products";
		ipRef->title="www.thinfilm.com";
		ipRef->journal="2005";
		ipRef->comment="wartosc dla In bonding, ale nie podano dla jakiej temperatury";
	}
    return ( 1.392e7 );
}
//---------------------------------------------------------------------------
double In::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Applied Thin-Film Products";
		ipRef->title="www.thinfilm.com";
		ipRef->journal="2005";
		ipRef->comment="wartosc dla In bonding, ale nie podano dla jakiej temperatury";
	}
    return ( 1. / ec(iT) );
}
//---------------------------------------------------------------------------
double In::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		//ipRef->author="Applied Thin-Film Products";
		//ipRef->title="www.thinfilm.com";
		//ipRef->journal="2005";
		
		ipRef->author="";
		ipRef->title="";
		ipRef->journal="trzeba znalezc literature";
		ipRef->comment="moje przekonanie i dane z sieci - RPS";
	}
	//return ( (0.939 - 6.96e-4 * iT + 9.86e-7 * iT*iT) * 100 );
	return ( 86.00 );
}
//---------------------------------------------------------------------------
double In::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 0.233e3 );
}
//---------------------------------------------------------------------------
double In::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 7.31e3 );
}
//---------------------------------------------------------------------------
double In::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.I. Golovashkin, I.S. Levchenko, G.P. Motulevich, A.A. Shubin";
		ipRef->title="Optical properties of indium";
		ipRef->journal="Soviet Physics JETP 24, no. 6 (1967) 1093-1100";
		ipRef->comment="dla dlugosci fali 2-10 um";
	}
	
	return ( 1.18*pow(iLam/1e3,1.32) );
}
//---------------------------------------------------------------------------
double In::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.I. Golovashkin, I.S. Levchenko, G.P. Motulevich, A.A. Shubin";
		ipRef->title="Optical properties of indium";
		ipRef->journal="Soviet Physics JETP 24, no. 6 (1967) 1093-1100";
		ipRef->comment="dla dlugosci fali 2-10 um";
	}
	
	return ( 9.81e5*exp(-0.04*(iLam/1e3)) );}
//---------------------------------------------------------------------------
In::In()
{
}
//---------------------------------------------------------------------------
In::~In()
{
}