#include "pch.h"

#include "InAlGaN.h"
//---------------------------------------------------------------------------
double InAlGaN::a(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.a(iT) + mAl*mAlN.a(iT) + mGa*mGaN.a(iT) );
}
//---------------------------------------------------------------------------
double InAlGaN::c(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.c(iT) + mAl*mAlN.c(iT) + mGa*mGaN.c(iT) );
}
//---------------------------------------------------------------------------
double InAlGaN::ea(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="http://www.ioffe.ru/SVA/NSM oraz ssg.als.lbl.gov/ssgdirectory/guo/wladek_rixs07.pdf";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.ea() + mAl*mAlN.ea() + mGa*mGaN.ea() );
}
//---------------------------------------------------------------------------
double InAlGaN::Eg(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 24";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.Eg(iT) + mAl*mAlN.Eg(iT) + mGa*mGaN.Eg(iT) - mIn*mAl*3.4 - mIn*mGa*1.4 - mAl*mGa*0.7 ); // - mIn*mAl*mGa*0.
}
//---------------------------------------------------------------------------
double InAlGaN::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.Dso() + mAl*mAlN.Dso() + mGa*mGaN.Dso() );
}
//---------------------------------------------------------------------------
double InAlGaN::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.me() + mAl*mAlN.me() + mGa*mGaN.me() );
}
//---------------------------------------------------------------------------
double InAlGaN::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.mhh() + mAl*mAlN.mhh() + mGa*mGaN.mhh() );
}
//---------------------------------------------------------------------------
double InAlGaN::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.mlh() + mAl*mAlN.mlh() + mGa*mGaN.mlh() );
}
//---------------------------------------------------------------------------
double InAlGaN::meL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.meL() + mAl*mAlN.meL() + mGa*mGaN.meL() );
}
//---------------------------------------------------------------------------
double InAlGaN::meT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.meT() + mAl*mAlN.meT() + mGa*mGaN.meT() );
}
//---------------------------------------------------------------------------
double InAlGaN::mhhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.mhhL() + mAl*mAlN.mhhL() + mGa*mGaN.mhhL() );
}
//---------------------------------------------------------------------------
double InAlGaN::mhhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.mhhT() + mAl*mAlN.mhhT() + mGa*mGaN.mhhT() );
}
//---------------------------------------------------------------------------
double InAlGaN::mlhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.mlhL() + mAl*mAlN.mlhL() + mGa*mGaN.mlhL() );
}
//---------------------------------------------------------------------------
double InAlGaN::mlhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}	return ( mIn*mInN.mlhT() + mAl*mAlN.mlhT() + mGa*mGaN.mlhT() );
}
//------------------------------------------------------------------------------
double InAlGaN::mh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3";
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double InAlGaN::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN; punktem odniesienia jest Ev=0eV dla AlN";
	}
	return ( mIn * mInN.Ev() + mAl * mAlN.Ev() + mGa * mGaN.Ev() );
}
//------------------------------------------------------------------------------
double InAlGaN::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( Ev() + Eg(iT) );
}
//---------------------------------------------------------------------------
double InAlGaN::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.c11() + mAl*mAlN.c11() + mGa*mGaN.c11() );
}
//---------------------------------------------------------------------------
double InAlGaN::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.c12() + mAl*mAlN.c12() + mGa*mGaN.c12() );
}
//---------------------------------------------------------------------------
double InAlGaN::c13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.c13() + mAl*mAlN.c13() + mGa*mGaN.c13() );
}
//---------------------------------------------------------------------------
double InAlGaN::c33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.c33() + mAl*mAlN.c33() + mGa*mGaN.c33() );
}
//---------------------------------------------------------------------------
double InAlGaN::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.c44() + mAl*mAlN.c44() + mGa*mGaN.c44() );
}
//---------------------------------------------------------------------------
double InAlGaN::d13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.d13() + mAl*mAlN.d13() + mGa*mGaN.d13() );
}
//---------------------------------------------------------------------------
double InAlGaN::d15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.d15() + mAl*mAlN.d15() + mGa*mGaN.d15() );
}
//---------------------------------------------------------------------------
double InAlGaN::d33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.d33() + mAl*mAlN.d33() + mGa*mGaN.d33() );
}
//---------------------------------------------------------------------------
double InAlGaN::e15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.e15() + mAl*mAlN.e15() + mGa*mGaN.e15() );
}
//---------------------------------------------------------------------------
double InAlGaN::e31(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.e31() + mAl*mAlN.e31() + mGa*mGaN.e31() );
}
//---------------------------------------------------------------------------
double InAlGaN::e33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.e33() + mAl*mAlN.e33() + mGa*mGaN.e33() );
}
//---------------------------------------------------------------------------
double InAlGaN::Psp(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.Psp() + mAl*mAlN.Psp() + mGa*mGaN.Psp() );
}
//------------------------------------------------------------------------------
double InAlGaN::Nc(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double InAlGaN::Nv(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double InAlGaN::ni(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//---------------------------------------------------------------------------
double InAlGaN::n(double iT, double iN, std::string iDop, reference *ipRef)
{
	double carr(0); // TODO
	return carr;
}
//---------------------------------------------------------------------------
double InAlGaN::mob(double iT, double iN, std::string iDop, reference *ipRef)
{
	double mob(0); // TODO
	return mob;
}
//---------------------------------------------------------------------------
double InAlGaN::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
    double sigma(0); // TODO
    return sigma;
}
//---------------------------------------------------------------------------
double InAlGaN::k(double iT, double iN, std::string iDop, reference *ipRef)
{
    double k(0); // TODO
    return k;
}
//---------------------------------------------------------------------------
double InAlGaN::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( mIn*mInN.cp(iT) + mAl*mAlN.cp(iT) + mGa*mGaN.cp(iT) );
}
//---------------------------------------------------------------------------
double InAlGaN::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( mIn*mInN.g(iT) + mAl*mAlN.g(iT) + mGa*mGaN.g(iT) );
}
//---------------------------------------------------------------------------
double InAlGaN::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 164-165";
		ipRef->comment="wartosc interpolowana z danych dla InN, AlN i GaN";
	}
	return ( mIn*mInN.dc() + mAl*mAlN.dc() + mGa*mGaN.dc() );
}
//---------------------------------------------------------------------------
double InAlGaN::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="nR(lam,300K) dla GaN z uwzglednieniem roznicy pomiedzy Eg GaN i InAlGaN";
	}
	double tE = cPhys::h_eVc1e9/iLam - (Eg(iT) - mGaN.Eg(300.)),
	       nR(0);

    if (tE > 1.000 && tE < 2.139) nR = 0.013914*tE*tE*tE*tE - 0.096422*tE*tE*tE + 0.27318*tE*tE - 0.27725*tE + 2.3535;      // lambda: 580nm - 1240nm
	if (tE > 2.138 && tE < 3.164) nR = 0.1152*tE*tE*tE - 0.7955*tE*tE + 1.959*tE + 0.68;                                    // lambda: 392nm - 580nm
	if (tE > 3.163 && tE < 3.352) nR = 18.2292*tE*tE*tE - 174.6974*tE*tE + 558.535*tE - 593.164;                            // lambda: 370nm - 392nm
	if (tE > 3.351 && tE < 3.533) nR = 33.63905*tE*tE*tE - 353.1446*tE*tE + 1235.0168*tE - 1436.09;                         // lambda: 351nm - 370nm
	if (tE > 3.532 && tE < 4.101) nR = -0.72116*tE*tE*tE + 8.8092*tE*tE - 35.8878*tE + 51.335;                              // lambda: 336nm - 351nm
    if (tE > 4.100 && tE < 5.000) nR = 0.351664*tE*tE*tE*tE - 6.06337*tE*tE*tE + 39.2317*tE*tE - 112.865*tE + 124.358;      // lambda: 248nm - 336nm

	return nR;
}
//---------------------------------------------------------------------------
double InAlGaN::abs(double iLam, double iT, double iN, std::string iDop, reference *ipRef)
{
    double dE = cPhys::h_eVc1e9/iLam - Eg(iT);
	double tN = iN*1e-24;

    if (iDop=="Mg")
		return ( (19000.+200.*tN)*exp(dE/(0.019+0.0001*tN))+(330.+30.*tN)*exp(dE/(0.07+0.0008*tN)) );
    else
	{
		double tNgr = -0.0003878*iLam*iLam + 0.3946*iLam - 90.42;
		if (tN > tNgr) // Perlin
		{
			double tn = n(iT,iN,iDop)*1e-24;
			return ( (33500.*exp(0.08*tn))*exp((-0.00018*tn - 0.0135)*iLam) ); // (przed 17.01.2014 tylko taka zaleznosc dla n-GaN)
		}
		else // Piprek
			return ( (19000.+4000.*tN) * exp(dE/(0.019+0.001*tN)) + (330.+200.*tN) * exp(dE/(0.07+0.016*tN)) );
	}
}
//---------------------------------------------------------------------------
InAlGaN::InAlGaN(double iIn, double iAl)
{
    mIn = iIn;
	mAl = iAl;
	mGa = 1.-iIn-iAl;
}
//---------------------------------------------------------------------------
InAlGaN::InAlGaN()
{
}
//---------------------------------------------------------------------------
InAlGaN::~InAlGaN()
{
}
