/*##############################################################################
#                                                                              #
# dane materialowe dla InAlGaN (wurcyt)                                        #
#                                                                              #
# data dodania pliku do bazy materialowej: 08-05-2013                          #
# data ostatniej modyfikacji: 17-12-2013                                       #
# autorzy kodu: MACIEJ KUC (maciej.kuc@p.lodz.pl)					           #
#               LUKASZ PISKORSKI (lukasz.piskorski@p.lodz.pl)			       #
#                                                                              #
##############################################################################*/

#ifndef InAlGaN_h
#define InAlGaN_h

#include "headers.h"
#include "InN.h"
#include "AlN.h"
#include "GaN.h"

class InAlGaN : public material
{
    private:
        double mIn, mAl, mGa;
		GaN mGaN;
		InN mInN;
		AlN mAlN;

    public:
		double a(double iT, reference *ipRef=NULL);
		double c(double iT, reference *ipRef=NULL);
		double ea(reference *ipRef=NULL);
		double Eg(double iT, reference *ipRef=NULL);
		double Dso(reference *ipRef=NULL);
		double me(reference *ipRef=NULL);
		double mhh(reference *ipRef=NULL);
		double mlh(reference *ipRef=NULL);
		double meL(reference *ipRef=NULL);
		double meT(reference *ipRef=NULL);
		double mhhL(reference *ipRef=NULL);
		double mhhT(reference *ipRef=NULL);
		double mlhL(reference *ipRef=NULL);
		double mlhT(reference *ipRef=NULL);
		double mh(reference *ipRef=NULL);
        double Ev(reference *ipRef=NULL);
		double Ec(double iT, reference *ipRef=NULL);
		double c11(reference *ipRef=NULL);
		double c12(reference *ipRef=NULL);
		double c13(reference *ipRef=NULL);
		double c33(reference *ipRef=NULL);
		double c44(reference *ipRef=NULL);
		double d13(reference *ipRef=NULL);
		double d15(reference *ipRef=NULL);
		double d33(reference *ipRef=NULL);
		double e15(reference *ipRef=NULL);
		double e31(reference *ipRef=NULL);
		double e33(reference *ipRef=NULL);
		double Psp(reference *ipRef=NULL);
		double Nc(double iT, reference *ipRef=NULL);
		double Nv(double iT, reference *ipRef=NULL);
		double ni(double iT, reference *ipRef=NULL);
		double n(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double mob(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double ec(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double k(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double cp(double iT, reference *ipRef=NULL);
		double g(double iT, reference *ipRef=NULL);
		double dc(reference *ipRef=NULL);
		double nR(double iLam, double iT, reference *ipRef=NULL);
		double abs(double iLam, double iT, double N, std::string iDop, reference *ipRef=NULL);
        InAlGaN(double iIn, double iAl);
		InAlGaN();
		~InAlGaN();
};

#endif
