/*##############################################################################
#                                                                              #
# dane materialowe dla InGaAs                                                  #
#                                                                              #
# data dodania pliku do bazy materialowej: 02-10-2006                          #
# data ostatniej modyfikacji: 17-12-2013                                       #
# autor kodu: LUKASZ PISKORSKI (lukasz.piskorski@p.lodz.pl)                    #
#                                                                              #
##############################################################################*/

#ifndef InGaAs_h
#define InGaAs_h

#include "headers.h"
#include "InAs.h"
#include "GaAs.h"

class InGaAs : public material // In(x)Ga(1-x)As
{
	private:
		double mIn, mGa;
		InAs mInAs;
		GaAs mGaAs;

	public:
		double cte(double iT, reference *ipRef=NULL);
		double a(double iT, reference *ipRef=NULL);    
		double Eg(double iT, char iPoint, reference *ipRef=NULL);
		double Eg(double iT, reference *ipRef=NULL);
		double Dso(reference *ipRef=NULL);
		double me(reference *ipRef=NULL);
		double mhh(reference *ipRef=NULL);
		double mlh(reference *ipRef=NULL);
		double mso(reference *ipRef=NULL);
		double mh(reference *ipRef=NULL);
		double Ev(reference *ipRef=NULL);
		double Ec(double iT, reference *ipRef=NULL);
		double ac(reference *ipRef=NULL);
		double av(reference *ipRef=NULL);
		double b(reference *ipRef=NULL);
		double d(reference *ipRef=NULL);
		double c11(reference *ipRef=NULL);
		double c12(reference *ipRef=NULL);
		double c44(reference *ipRef=NULL);
		double Nc(double iT, reference *ipRef=NULL);
		double Nv(double iT, reference *ipRef=NULL);
		double ni(double iT, reference *ipRef=NULL);
		double n(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double mob(double iT, double iN, std::string iDop, reference *ipRef=NULL);
		double ec(double iT, double iN, std::string iDop, reference *ipRef=NULL); // liczyc dla: Si, Zn; dla: Sn, Be, C takze mozna, ale przyjeto n=N 
		double k(double iT, reference *ipRef=NULL);
		double cp(double iT, reference *ipRef=NULL);
		double g(double iT, reference *ipRef=NULL);
		double nR(double iLam, double iT, reference *ipRef=NULL);
		double abs(double iLam, double iT, double iN, std::string iDop, reference *ipRef=NULL);
		InGaAs(double iIn);
		InGaAs();    
		virtual ~InGaAs();
};

#endif


