#include "pch.h"

#include "InGaN.h"
//---------------------------------------------------------------------------
double InGaN::a(double iT,reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.a(iT) + mGa * mGaN.a(iT) );
}
//---------------------------------------------------------------------------
double InGaN::c(double iT,reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.c(iT) + mGa * mGaN.c(iT) );
}
//---------------------------------------------------------------------------
double InGaN::ea(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="http://www.ioffe.ru/SVA/NSM oraz ssg.als.lbl.gov/ssgdirectory/guo/wladek_rixs07.pdf";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.ea() + mGa * mGaN.ea() );
}
//---------------------------------------------------------------------------
double InGaN::Eg(double iT,reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 24";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.Eg(iT) + mGa*mGaN.Eg(iT) - mIn*mGa*1.4 );
}
//---------------------------------------------------------------------------
double InGaN::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.Dso() + mGa*mGaN.Dso() );
}
//---------------------------------------------------------------------------
double InGaN::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.me() + mGa*mGaN.me() );
}
//---------------------------------------------------------------------------
double InGaN::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.mhh() + mGa*mGaN.mhh() );
}
//---------------------------------------------------------------------------
double InGaN::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.mlh() + mGa*mGaN.mlh() );
}
//---------------------------------------------------------------------------
double InGaN::meL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.meL() + mGa*mGaN.meL() );
}
//---------------------------------------------------------------------------
double InGaN::meT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.meT() + mGa*mGaN.meT() );
}
//---------------------------------------------------------------------------
double InGaN::mhhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.mhhL() + mGa*mGaN.mhhL() );
}
//---------------------------------------------------------------------------
double InGaN::mhhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN4";
	}
	return ( mIn * mInN.mhhT() + mGa*mGaN.mhhT() );
}
//---------------------------------------------------------------------------
double InGaN::mlhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.mlhL() + mGa*mGaN.mlhL() );
}
//---------------------------------------------------------------------------
double InGaN::mlhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.mlhT() + mGa*mGaN.mlhT() );
}
//------------------------------------------------------------------------------
double InGaN::mh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3";
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double InGaN::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.Ev() + mGa * mGaN.Ev() );
}
//------------------------------------------------------------------------------
double InGaN::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( Ev() + Eg(iT) );
}
//---------------------------------------------------------------------------
double InGaN::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN ";
	}
	return ( mIn * mInN.c11() + mGa * mGaN.c11() );
}
//---------------------------------------------------------------------------
double InGaN::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.c12() + mGa * mGaN.c12() );
}
//---------------------------------------------------------------------------
double InGaN::c13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.c13() + mGa * mGaN.c13() );
}
//---------------------------------------------------------------------------
double InGaN::c33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.c33() + mGa * mGaN.c33() );
}
//---------------------------------------------------------------------------
double InGaN::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.c44() + mGa * mGaN.c44() );
}
//---------------------------------------------------------------------------
double InGaN::d13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.d13() + mGa * mGaN.d13() );
}
//---------------------------------------------------------------------------
double InGaN::d15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.d15() + mGa * mGaN.d15() );
}
//---------------------------------------------------------------------------
double InGaN::d33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.d33() + mGa * mGaN.d33() );
}
//---------------------------------------------------------------------------
double InGaN::e15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.e15() + mGa * mGaN.e15() );
}
//---------------------------------------------------------------------------
double InGaN::e31(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.e31() + mGa * mGaN.e31() );
}
//---------------------------------------------------------------------------
double InGaN::e33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.e33() + mGa * mGaN.e33() );
}
//---------------------------------------------------------------------------
double InGaN::Psp(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.Psp() + mGa * mGaN.Psp() );
}
//---------------------------------------------------------------------------
double InGaN::Dcr(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mIn * mInN.Dcr() + mGa * mGaN.Dcr() );
}
//---------------------------------------------------------------------------
double InGaN::D1(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mIn * mInN.D1() + mGa * mGaN.D1() );
}
//---------------------------------------------------------------------------
double InGaN::D2(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mIn * mInN.D2() + mGa * mGaN.D2() );
}
//---------------------------------------------------------------------------
double InGaN::D3(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mIn * mInN.D3() + mGa * mGaN.D3() );
}
//---------------------------------------------------------------------------
double InGaN::D4(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( mIn * mInN.D4() + mGa * mGaN.D4() );
}
//------------------------------------------------------------------------------
double InGaN::Nc(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double InGaN::Nv(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double InGaN::ni(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//---------------------------------------------------------------------------
double InGaN::n(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mGa * mGaN.n(iT,iN,iDop) + mIn * mInN.n(iT,iN,iDop) );
}
//---------------------------------------------------------------------------
double InGaN::mob(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	double /*mob(0),*/ c(0);

	if(iDop == "Mg") c = 7.256e-25*n(iT,iN,iDop) + 0.377; // Mg-doped
	else c = -4.615e-27*n(iT,iN,iDop) + 0.55; // undoped/Si-doped

	return ( 1/(mIn/mInN.mob(iT,iN,iDop) + mGa/mGaN.mob(iT,iN,iDop) + mIn*mGa*(c*1e4)) );
}
//---------------------------------------------------------------------------
double InGaN::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
    double /*sigma(0),*/ delta(0);

    if(iDop == "Mg") delta = 4.787*exp(-8.768*mIn); // Mg-doped
    else delta = -0.04*mIn - 0.18; 						// undoped/Si-doped

   return ( cPhys::e * n(300.,iN,iDop) * mob(300.,iN,iDop) * pow(iT/300.,delta) );
}
//---------------------------------------------------------------------------
//double InGaN::k(double iT, double iN, std::string iDop, reference *ipRef)
double InGaN::k(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
    double k = 1./(mIn/120. + mGa/230. + mIn*mGa*1.5),
           delta = -1.4;

    return ( k*pow(iT/300.,delta) );
}
//---------------------------------------------------------------------------
double InGaN::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( mIn * mInN.cp(iT) + mGa*mGaN.cp(iT) );
}
//---------------------------------------------------------------------------
double InGaN::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( mIn * mInN.g(iT) + mGa*mGaN.g(iT) );
}
//---------------------------------------------------------------------------
double InGaN::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 164-165";
		ipRef->comment="wartosc interpolowana z danych dla InN i GaN";
	}
	return ( mIn * mInN.dc() + mGa * mGaN.dc() );
}
//---------------------------------------------------------------------------
double InGaN::nR(double iLam, double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="nR(lam,300K) dla GaN z uwzglednieniem roznicy pomiedzy Eg GaN i InGaN";
	}

    double tE = cPhys::h_eVc1e9 / iLam;
    double dE = 6.2 * mIn * mIn - 5.9 * mIn;
	double Enew = tE - dE;

	tE = Enew;
    double nR = 0.;
    if (tE <= 1.5)
    {
        tE = 1.5;
        nR = 0.013914*tE*tE*tE*tE - 0.096422*tE*tE*tE + 0.27318*tE*tE - 0.27725*tE + 2.3535; /// wczesniej bylo, ze nR = 0
    }
    else if (tE <= 2.135872)
        nR = 0.013914*tE*tE*tE*tE - 0.096422*tE*tE*tE + 0.27318*tE*tE - 0.27725*tE + 2.3535;
    else if (tE <= 3.163507)
        nR = 0.1152*tE*tE*tE - 0.7955*tE*tE + 1.959*tE + 0.68;
    else if (tE <= 3.357226)
        nR = 18.2292*tE*tE*tE - 174.6974*tE*tE + 558.535*tE - 593.164;
    else if (tE <= 3.469242)
        nR = 33.63905*tE*tE*tE - 353.1446*tE*tE + 1235.0168*tE - 1436.09;
    else if (tE <= 3.680144)
        nR = -0.72116*tE*tE*tE + 8.8092*tE*tE - 35.8878*tE + 51.335;
    else if (tE < 4.5)
        nR = 0.351664*tE*tE*tE*tE - 6.06337*tE*tE*tE + 39.2317*tE*tE - 112.865*tE + 124.358;
    else
    {
        tE = 4.5;
        nR = 0.351664*tE*tE*tE*tE - 6.06337*tE*tE*tE + 39.2317*tE*tE - 112.865*tE + 124.358; /// wczesniej bylo, ze nR = 0
    }

	double nR_undoped = nR;
	double nR_doped = 0.;

	if ((iDop == "Si" || iDop == "O"))
	{
        double tau = 1e-14; //[s]
        double m = me() * cPhys::m0; //[kg]
        double pic2 = 2. * cMath::pi * cPhys::c;
        ////double eps = nR_undoped * nR_undoped;
        /// double n_ = n(iT,iN,iDop); zmiana 30.03.2018
        double n_ = n(300.,iN,iDop); /// zmiana 30.03.2018
        double omegaP2 = n_ * (cPhys::e)*(cPhys::e) / (m*cPhys::epsilon0);
        double omega = pic2 / (iLam*1e-9);
        double omega2 = omega*omega;
        double deps = (1.-omegaP2/(omega2+1./(tau*tau)));
        double dnR = 100.*(1.-sqrt(deps));
        nR_doped = (nR_undoped-dnR*nR_undoped/100.);
	}
	else if (iDop == "Mg")
	{
        double tau = 1e-14; //[s]
        double m = mh() * cPhys::m0; //[kg]
        double pic2 = 2. * cMath::pi * cPhys::c;
        ////double eps = nR_undoped * nR_undoped;
        //double n_ = n(iT,iN,iDop);
        double n_ = iN;
        double omegaP2 = n_ * (cPhys::e)*(cPhys::e) / (m*cPhys::epsilon0);
        double omega = pic2 / (iLam*1e-9);
        double omega2 = omega*omega;
        double deps = (1.-omegaP2/(omega2+1./(tau*tau)));
        double dnR = 100.*(1.-sqrt(deps));
        nR_doped = (nR_undoped-dnR*nR_undoped/100.);
	}
    else // czyli takze i dla p-GaN
        nR_doped = nR_undoped;

    double _dnRdT_GaN = 42470. * pow(iLam,-3) - 159.2 * pow(iLam,-2) + 0.2187 * pow(iLam,-1) - 0.00003427;
    double _dnRdT_InN = 144.99 * pow(iLam,-2) - 0.23323 * pow(iLam,-1) + 0.00012071; /// to juz bylo w bazie - ale skad to jest wziete
    double _dnRdT_InGaN = mIn * _dnRdT_InN + (1. - mIn) * _dnRdT_GaN;
    return ( nR_doped + _dnRdT_InGaN * (iT - 300.) );
}
//---------------------------------------------------------------------------
double InGaN::abs(double iLam, double iT, double iN, std::string iDop, reference *ipRef)
{
    /*double dE = cPhys::h_eVc1e9/iLam - Eg(iT);
	double tN = iN*1e-24;

    if (iDop=="Mg")
		return ( (19000.+200.*tN)*exp(dE/(0.019+0.0001*tN))+(330.+30.*tN)*exp(dE/(0.07+0.0008*tN)) );
    else
	{
		double tNgr = -0.0003878*iLam*iLam + 0.3946*iLam - 90.42;
		if (tN > tNgr) // Perlin
		{
			double tn = n(iT,iN,iDop)*1e-24;
			return ( (33500.*exp(0.08*tn))*exp((-0.00018*tn - 0.0135)*iLam) ); // (przed 17.01.2014 tylko taka zaleznosc dla n-GaN)
		}
		else // Piprek
			return ( (19000.+4000.*tN) * exp(dE/(0.019+0.001*tN)) + (330.+200.*tN) * exp(dE/(0.07+0.016*tN)) );
	}*/
	double dE = cPhys::h_eVc1e9/iLam - Eg(iT); // dE = E - Eg
	if ((iDop == "Si" || iDop == "O"))
	{
        double n_ = (n(iT,iN,iDop)) * 1e-24;
        if (n_ < 1.)
            n_ = 1.;
        double c1 = -18985. * pow(n_, -1.00021); // dopasowanie (P) do danych z R. Kucharski, Transparency of Semi-Insulating, n-Type, and p-Type ..., Crystals 2017, 7, 187
        double c2 = (0.40952-7.19e-3*n_+1.30887e-4*n_*n_) * pow(n_, -0.79); // dopasowanie (P) do danych z R. Kucharski, Transparency of Semi-Insulating, n-Type, and p-Type ..., Crystals 2017, 7, 187
        return ( (19000.+c1*n_) * exp(dE/(0.019+c2*n_)) + (330.+0.001*n_) * exp(dE/(0.07+0.0005*n_)) ); // postac wzoru z Piprek et al., SPIE 6766 (2007) 67660H
	}
	else
    {
        double P = iN * 1e-24;
        return ( (19000.+200.*P) * exp(dE/(0.019+0.0001*P)) + (330.+30.*P) * exp(dE/(0.07+0.0008*P)) ); //Piprek et al., SPIE 6766 (2007) 67660H
    }
}
//---------------------------------------------------------------------------
InGaN::InGaN(double iIn)
{
    mIn = iIn;
    mGa = 1.-iIn;
}
//---------------------------------------------------------------------------
InGaN::InGaN()
{
}
//---------------------------------------------------------------------------
InGaN::~InGaN()
{
}





