#include "pch.h"

#include "InGaN_g.h"
//------------------------------------------------------------------------------
double InGaN_g::k(double iT, double iNdop, std::string iDop, char iDir, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="standardowe zaleznosci dla materialow warstwowych";
		ipRef->comment="k(t) = SUM(d_i)/SUM(d_i/k_i); k(l) = SUM(d_i*k_i)/SUM(d_i)";
	}
	double tSum = 0.;
	for (int i=0; i<100; i++)
	{
		double tXIn = mXIn1+i*(mXIn2-mXIn1)/99.;
		InGaN tInGaN = InGaN(tXIn);
		if (iDir == 't')
			tSum += (1. / tInGaN.k(iT,iNdop,iDop));
		else if (iDir == 'l')
			tSum += tInGaN.k(iT,iNdop,iDop);
	}
	if (iDir == 't') return (100. / tSum);
	else if (iDir == 'l') return (tSum * 0.01);
	else return 0.;
}
//------------------------------------------------------------------------------
double InGaN_g::ec(double iT, double iNdop, std::string iDop, char iDir, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="standardowe zaleznosci dla materialow warstwowych";
		ipRef->comment="sigma(l) = SUM(d_i*sigma_i)/SUM(d_i); sigma(t) = SUM(d_i)/SUM(d_i/sigma_i)";
	}
	double tSum = 0.;
	for (int i=0; i<100; i++)
	{
		double tXIn = mXIn1+i*(mXIn2-mXIn1)/99.;
		InGaN tInGaN = InGaN(tXIn);
		if (iDir == 'l')
			tSum += (cPhys::e * tInGaN.n(iT,iNdop,iDop) * tInGaN.mob(iT,iNdop,iDop));
		else if (iDir == 't')
			tSum += (1. / (cPhys::e * tInGaN.n(iT,iNdop,iDop) * tInGaN.mob(iT,iNdop,iDop)));
	}
	if (iDir == 'l') return (tSum * 0.01);
	else if (iDir == 't') return (100. / tSum);
	else return 0.;     
}
//------------------------------------------------------------------------------
InGaN_g::InGaN_g(double iXIn1, double iXIn2)
{
	mXIn1 = iXIn1;
	mXIn2 = iXIn2;
}
//------------------------------------------------------------------------------
InGaN_g::InGaN_g()
{  
}
//------------------------------------------------------------------------------
InGaN_g::~InGaN_g()
{
}
//------------------------------------------------------------------------------
