#include "pch.h"

#include "InN.h"
//---------------------------------------------------------------------------
double InN::a(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 3.545;
}
//---------------------------------------------------------------------------
double InN::c(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 5.703;
}
//---------------------------------------------------------------------------
double InN::ea(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="W. Walukiewicz";
		ipRef->title="New materials for high efficiency solar cells";
		ipRef->journal="RIXS Workshop 2007, ssg.als.lbl.gov/ssgdirectory/guo/wladek_rixs07.pdf";
		ipRef->comment="-";
	}
	return 5.8;
}
//---------------------------------------------------------------------------
double InN::Eg(double iT,reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 24";
		ipRef->comment="-";
	}
	return ( cFunc::Varshni(0.69, 0.414e-3, 154., iT) );
}
//---------------------------------------------------------------------------
double InN::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 0.005;
}
//---------------------------------------------------------------------------
double InN::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="-";
	}
	return 0.07;
}
//---------------------------------------------------------------------------
double InN::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="-";
	}
	return 1.63;
}
//---------------------------------------------------------------------------
double InN::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 7-12";
		ipRef->comment="-";
	}
	return 0.27;
}
//---------------------------------------------------------------------------
double InN::meL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment=" ";
	}
	return 0.039;
}
//---------------------------------------------------------------------------
double InN::meT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment=" ";
	}
	return 0.047;
}
//---------------------------------------------------------------------------
double InN::mhhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A1+A3), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 1.54;
}
//---------------------------------------------------------------------------
double InN::mhhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A2+A4-A5), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 1.41;
}
//---------------------------------------------------------------------------
double InN::mlhL(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A1+A3), wzor z pracy: Phys. Rev. B, 69, 165204, 2004";
	}
	return 1.54;
}
//---------------------------------------------------------------------------
double InN::mlhT(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009, p. 231";
		ipRef->comment="mhhL(m0)=-1/(A2+A4+A5), wzor z pracy: Phys.Rev.B, 69, 165204, 2004 z uwzgl. APL, 67 (17), 2527-9, 1995";
	}
	return 0.10;
}
//------------------------------------------------------------------------------
double InN::mh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3";
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double InN::Ev(reference *ipRef)
{
    if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Yi-Chia Tsai and Can Bayram";
		ipRef->title="Band Alignments of Ternary Wurtzite and Zincblende III-Nitrides Investigated by Hybrid Density Functional Theory";
		ipRef->journal="ACS Omega 2020, 5, 8, 39173923. https://doi.org/10.1021/acsomega.9b03353";
		ipRef->comment=" ";
	}
	return ( 1.15 );
	/*if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 1.29 );*/
	//return ( -2.34 );
}
//------------------------------------------------------------------------------
double InN::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( Ev() + Eg(iT) );
}
//---------------------------------------------------------------------------
double InN::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 223.;
}
//---------------------------------------------------------------------------
double InN::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 115.;
}
//---------------------------------------------------------------------------
double InN::c13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 92.;
}
//---------------------------------------------------------------------------
double InN::c33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 224.;
}
//---------------------------------------------------------------------------
double InN::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 48.;
}
//---------------------------------------------------------------------------
double InN::d13(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -3.5;
}
//---------------------------------------------------------------------------
double InN::d15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 5.5;
}
//---------------------------------------------------------------------------
double InN::d33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 7.6;
}
//---------------------------------------------------------------------------
double InN::e15(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return -0.112;
}
//---------------------------------------------------------------------------
double InN::e31(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return -0.412;
}
//---------------------------------------------------------------------------
double InN::e33(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J. Piprek";
		ipRef->title="Nitride Semiconductor Devices - Principles and Simulation";
		ipRef->journal="Wiley VCH, 2007, p. 53";
		ipRef->comment="-";
	}
	return 0.815;
}
//---------------------------------------------------------------------------
double InN::Psp(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -0.042;
}
//---------------------------------------------------------------------------
double InN::Dcr(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 0.040;
}
//---------------------------------------------------------------------------
double InN::D1(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -3.7;
}
//---------------------------------------------------------------------------
double InN::D2(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 4.5;
}
//---------------------------------------------------------------------------
double InN::D3(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return 8.2;
}
//---------------------------------------------------------------------------
double InN::D4(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return -4.1;
}
//------------------------------------------------------------------------------
double InN::Nc(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double InN::Nv(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double InN::ni(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor";
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//---------------------------------------------------------------------------
double InN::n(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
	double carr(0);

	if(iDop == "Si")	carr = (iN*1e-6)*(-3.802e-6*iT*iT + 3.819e-3*iT + 0.1965);
	else if(iDop == "Mg")	carr = 7.392e9*pow(iN*1e-6,0.439);

	return (carr*1e6);
}
//---------------------------------------------------------------------------
double InN::mob(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
	double mob(0);

	if(iDop == "Si")	mob = 2.753e13*pow(n(300.,iN,"Si")*1e-6,-0.559)*(5.174e-6*iT*iT - 5.241e-3*iT + 2.107);
	else if(iDop == "Mg")	mob = 5.739e13*pow(n(300.,iN,"Mg")*1e-6,-0.663);

	return (mob*1e-4);
}
//---------------------------------------------------------------------------
double InN::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
    double carr(0), //koncentracja nosnikow [1/cm^3]
           tmob(0), //ruchliwosc nosnikow [cm^2/Vs]
           delta(0);//, //wykladnik w zaleznosci temperaturowej [-]
           //sigma(0);

    //Mg-doped InN
    if(iDop == "Mg") {
        carr = n(300.,iN,"Mg");
        tmob  = mob(300.,iN,"Mg");
        delta = 0.;
    }
    //undoped/Si-doped InN
    else {
        carr = n(300.,iN,"Si");
        tmob  = mob(300.,iN,"Si");
        delta = -0.2;
    }

    return ( cPhys::e * carr * tmob * pow(iT/300.,delta) );
}
//---------------------------------------------------------------------------
double InN::k(double /*iT*/, double /*iN*/, std::string /*iDop*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="M. Kuc, R.P. Sarzala and W. Nakwaski";
		ipRef->title="Thermal crosstalk in arrays of III-N-based lasers";
		ipRef->journal="Materials Science and Engineering B, vol. 178, pp. 1395-1402, 2013";
		ipRef->comment="-";
	}
    return ( 120. ); // brak danych literaturowych
}
//---------------------------------------------------------------------------
double InN::cp(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 2.274e3 );
}
//---------------------------------------------------------------------------
double InN::g(double /*iT*/, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 6.813e3 );
}

//------------------------------------------------------------------------------
double InN::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="H. Morkoc";
		ipRef->title="Nitride Semiconductor Devices - Fundamentals and Applications";
		ipRef->journal="Wiley-VCH, 2013, pp. 164-165";
		ipRef->comment="-";
	}
	return ( 15.3 );
}
//---------------------------------------------------------------------------
double InN::nR(double /*iLam*/, double /*iT*/, double /*N*/, std::string /*iDop*/, reference */*ipRef*/)
{
	return 0.; // TODO
}
//---------------------------------------------------------------------------
double InN::abs(double /*iLam*/, double /*iT*/, double /*N*/, std::string /*iDop*/, reference */*ipRef*/)
{
	return 0.; // TODO
}
//---------------------------------------------------------------------------
InN::InN(double it)
{
    mt = it; // (um)
}




