#include "pch.h"

#include "InNzb.h"
//------------------------------------------------------------------------------
double InNzb::a(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 4.98+2.83e-5*(iT-300.) );
}
//------------------------------------------------------------------------------
double InNzb::Eg(double iT, char iPoint, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	if (iPoint == 'G') return ( cFunc::Varshni(0.78, 0.245e-3, 624., iT) );
	else if (iPoint == 'X') return ( cFunc::Varshni(2.51, 0.245e-3, 624., iT) );
	else if (iPoint == 'L') return ( cFunc::Varshni(5.82, 0.245e-3, 624., iT) );
	else return 0.;
}
//------------------------------------------------------------------------------
double InNzb::Eg(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	double tEgG = Eg(iT, 'G');
	double tEgX = Eg(iT, 'X');
	double tEgL = Eg(iT, 'L');
	if ((tEgG <= tEgX) && (tEgG <= tEgL)) return tEgG;
	else if (tEgX <= tEgL) return tEgX;
	else return tEgL;
}
//------------------------------------------------------------------------------
double InNzb::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 0.005 );
}
//------------------------------------------------------------------------------
double InNzb::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 0.03 );
}
//------------------------------------------------------------------------------
double InNzb::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 1.261 );
}
//------------------------------------------------------------------------------
double InNzb::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 0.100 );
}
//------------------------------------------------------------------------------
double InNzb::mso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 0.3 );
}
//------------------------------------------------------------------------------
double InNzb::mh(reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3"; 
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double InNzb::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment="punktem odniesienia jest Ev=0eV dla InSb";
	}
	return ( -2.34 );
}
//------------------------------------------------------------------------------
double InNzb::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( Ev() + Eg(iT) );
}
//------------------------------------------------------------------------------
double InNzb::ac(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( -2.65 );
}
//------------------------------------------------------------------------------
double InNzb::av(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( -0.7 );
}
//------------------------------------------------------------------------------
double InNzb::b(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( -1.2 );
}
//------------------------------------------------------------------------------
double InNzb::d(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( -9.3 );
}
//------------------------------------------------------------------------------
double InNzb::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 187. );
}
//------------------------------------------------------------------------------
double InNzb::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 125. );
}
//------------------------------------------------------------------------------
double InNzb::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman and J. R. Meyer";
		ipRef->title="Band parameters for nitrogen-containing semiconductors";
		ipRef->journal="Journal of Applied Physics, vol. 94, no. 6, pp. 3675-3696, 2003";
		ipRef->comment=" ";
	}
	return ( 86. );
}
//------------------------------------------------------------------------------
double InNzb::Nc(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double InNzb::Nv(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double InNzb::ni(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//---------------------------------------------------------------------------
double InNzb::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 6.903e3 );
}

//------------------------------------------------------------------------------
InNzb::InNzb()
{
}
//------------------------------------------------------------------------------
InNzb::~InNzb()
{
}
//------------------------------------------------------------------------------