#include "pch.h"

#include "InP.h"
//---------------------------------------------------------------------------
double InP::cte(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi, ed.";
		ipRef->title="Handbook on Physical Properties of Semiconductors, vol. 2 III-V Compound Semiconductors, Chapter 16";
		ipRef->journal="Kluwer Academic Publishers, 2004";
		ipRef->comment="wartosc dla T: 300-570 K";
	}
    return ( 4.6e-6 );
}
//------------------------------------------------------------------------------
double InP::a(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( 5.8697+2.79e-5*(iT-300.) );
}
//------------------------------------------------------------------------------
double InP::Eg(double iT, char iPoint, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	if (iPoint == 'G') return ( cFunc::Varshni(1.4236, 0.363e-3, 162., iT) );
	else if (iPoint == 'X') return ( 2.384 - 3.7e-4 * iT );
	else if (iPoint == 'L') return ( cFunc::Varshni(2.014, 0.363e-3, 162., iT) );
	else return 0.;
}
//------------------------------------------------------------------------------
double InP::Eg(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( Eg(iT, 'G') );
}
//------------------------------------------------------------------------------
double InP::Dso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( 0.108 );
}
//------------------------------------------------------------------------------
double InP::me(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 0.07927 );
}
//------------------------------------------------------------------------------
double InP::mhh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 0.46 );
}
//------------------------------------------------------------------------------
double InP::mlh(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	}
	return ( 0.12 );
}
//------------------------------------------------------------------------------
double InP::mso(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( 0.21 );
}
//------------------------------------------------------------------------------
double InP::mh(reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="mh = (mlh^3/2+mhh^3/2)^2/3"; 
	}
	return ( pow(pow(mlh(), 1.5) + pow(mhh(), 1.5), 2./3.) );
}
//------------------------------------------------------------------------------
double InP::Ev(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="punktem odniesienia jest Ev=0eV dla InSb";
	}
	return ( -0.94 );
}
//------------------------------------------------------------------------------
double InP::Ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment=" ";
	}
	return ( Ev() + Eg(iT) );
}
//------------------------------------------------------------------------------
double InP::ac(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( -6.0 );
}
//------------------------------------------------------------------------------
double InP::av(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( -0.6 );
}
//------------------------------------------------------------------------------
double InP::b(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( -2.0 );
}
//------------------------------------------------------------------------------
double InP::d(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( -5.0 );
}
//------------------------------------------------------------------------------
double InP::c11(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( 101.1 );
}
//------------------------------------------------------------------------------
double InP::c12(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( 56.1 );
}
//------------------------------------------------------------------------------
double InP::c44(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Vurgaftman, J. R. Meyer, and L. R. Ram-Mohan";
		ipRef->title="Band parameters for III-V compound semiconductors and their alloys";
		ipRef->journal="Journal of Applied Physics, vol. 89, no. 11, pp. 5815-5875, 2001";
		ipRef->comment="-";
	}
	return ( 45.6 );
}
//------------------------------------------------------------------------------
double InP::Nc(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nc(iT, me()) );
}
//------------------------------------------------------------------------------
double InP::Nv(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::Nv(iT, mh()) );
}
//------------------------------------------------------------------------------
double InP::ni(double iT, reference *ipRef)
{ 
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cFunc::ni(iT, me(), mh(), Eg(iT)) );
}
//------------------------------------------------------------------------------
double InP::n(double iT, double iN, std::string iDop, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Lukasz Piskorski";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podstawie danych eksperymentalnych z roznych prac"; 
	}
	if (iDop == "Si")
		return ( iN ); // (dopasowanie do danych eksp.: Lukasz)
	else if (iDop == "Zn")
		return ( 0.75*iN ); // (dopasowanie do danych eksp.: Lukasz)
	else		
		return iN; // TODO
}
//------------------------------------------------------------------------------
double InP::mob(double iT, double iN, std::string iDop, reference *ipRef) 
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Lukasz Piskorski";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podstawie danych eksperymentalnych z roznych prac"; 
	}
	if (iDop == "Si")
	{
		double tInP_miRT = 3900e-4/(1+pow(n(300., iN, iDop)/1e24,0.51)); // (m^2/(V*s)) (dopasowanie do danych eksp.: Lukasz)
		return ( tInP_miRT * pow(300./iT,0.8) ); // (0.8 -> ref: rozprawa Lukasza)		
	}
	else if (iDop == "Zn")
	{
		double tInP_miRT = 120e-4/(1+pow(n(300., iN, iDop)/2e24,1.00)); // (m^2/(V*s)) (dopasowanie do danych eksp.: Lukasz)
		return ( tInP_miRT * pow(300./iT,2.0) ); // (2.0 -> ref: rozprawa Lukasza)		
	}
	else if (iDop == "Be")
	{
		double tInP_miRT = 140e-4/(1+pow(n(300., iN, iDop)/1e24,0.50)); // (m^2/(V*s)) (dopasowanie do danych eksp.: Lukasz)
		return ( tInP_miRT * pow(300./iT,2.0) ); // (2.0 -> ref: rozprawa Lukasza)		
	}
	else
		return 0.;
}
//------------------------------------------------------------------------------
double InP::ec(double iT, double iN, std::string iDop, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="standardowy wzor"; 
	}
	return ( cPhys::e * mob(iT, iN, iDop) * n(iT, iN, iDop) );       
}
//------------------------------------------------------------------------------
double InP::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" "; 
	} 
	return ( 68.*pow(300./iT,1.42) );
}
//---------------------------------------------------------------------------
double InP::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I. Barin, O. Knacke, O. Kubaschewski";
		ipRef->title="Thermomechanical Properties of Inorgarnic Substrates";
		ipRef->journal="Springer, Berlin, 1977";
		ipRef->comment="wartosci dla T: 300‒900 K";
	}
	return ( 310 + 0.1*(iT - 300) );
}
//---------------------------------------------------------------------------
double InP::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Handbook on Physical Properties of Semiconductors, vol. 2 III-V Compound Semiconductors, Chapter 16";
		ipRef->journal="Kluwer Academic Publishers, 2004";
		ipRef->comment="wartosci dla T: 300‒600 K";
	}
	return ( 4790 - 0.0659*(iT - 300) );
}

//------------------------------------------------------------------------------
double InP::nR(double iLam, double iT, reference *ipRef) 
{
	double tnR = 0;
	
	if (iLam >= 1200 && iLam <= 1600)
	{
		if(ipRef!=NULL)
		{
			ipRef->reset();
			ipRef->author="E. Gini and H. Melchior";
			ipRef->title="The refractive index of InP and its temperature dependence in the wavelength range from 1.2 um to 1.6 um";
			ipRef->journal="Eighth International Conference on Indium Phosphide and Related Materials, 21-25 Apr 1996, pp. 594-597";
			ipRef->comment="zaleznosc poprawna dla przedzialu 1200-1600 nm";
		}
		double tLam2 = iLam*iLam*1e-6;
		double nR_25C = sqrt(7.233+2.34*tLam2/(tLam2-0.382));
		double dnRdT = (pow(iLam*1e-3-1.58,2.)+0.73)*2.6e-4;
		
		tnR = nR_25C + dnRdT * (iT-273.15-25.);
	}
	else
	{
		if(ipRef!=NULL)
		{
			ipRef->reset();
			ipRef->author="-";
			ipRef->title="-";
			ipRef->journal="refractiveindex.info";
			ipRef->comment="zaleznosc dla dlugosci fali 0.95-10 um";
		}
		double tLam = iLam/1e3; //dlugosc fali w mikronach
		tnR = pow((7.255 + 2.316*tLam*tLam/(tLam*tLam - 0.6263*0.6263) + 2.765*tLam*tLam/(tLam*tLam - 32.935*32.935)),0.5);
		tnR = tnR + 2.7e-5*(iT - 300); //long-wavelength limit from S. Adachi, Handbook on Physical Properties of Semiconductors, vol. 2 III-V Compound Semiconductors, Chapter 16, Kluwer Academic Publishers, 2004
	}
	
	return ( tnR );
}
//------------------------------------------------------------------------------
double InP::abs(double iLam, double iT, double iN, std::string iDop, reference *ipRef) 
{
	double tAbs300 = 0.;
	char tType = '-';
	
	if (iLam <= 9000.)
	{
		if(ipRef!=NULL)
		{
			ipRef->reset();
			ipRef->author="Lukasz Piskorski";
			ipRef->title="-";
			ipRef->journal="-";
			ipRef->comment="na podstawie danych eksperymentalnych z roznych prac";
		}
		if ( (iDop == "C") || (iDop == "Zn") || (iDop == "Be") )
			tType = 'p';
		else if ( (iDop == "Si") || (iDop == "Te") || (iDop == "Se") || (iDop == "Sn") || (iDop == "S") )
			tType = 'n';
		double tn = n(iT, iN, iDop) * 1e-6;
		if (tType == 'p')
		{
			if (iLam == 1300.)		tAbs300 = 23. * pow(tn*1e-18, 0.7);
			else if (iLam == 1550.)	tAbs300 = 38. * pow(tn*1e-18, 0.7);
			else if (iLam == 2330.)	tAbs300 = 52. * pow(tn*1e-18, 1.2);
			else if (iLam == 9000.)	tAbs300 = 200. * (tn*1e-18);
		}
		else if (tType == 'n')
		{
			if (iLam == 1300.)		tAbs300 = 1.6 * pow(tn*1e-18, 0.94);  
			else if (iLam == 1550.)	tAbs300 = 0.7 * pow(tn*1e-18, 1.14);
			else if (iLam == 2330.)	tAbs300 = 2. * (tn*1e-18);
			else if (iLam == 9000.)	tAbs300 = 58. * (tn*1e-18);
		}
	}
	else
	{
		if(ipRef!=NULL)
		{
			ipRef->reset();
			ipRef->author="R. Newman";
			ipRef->title="-";
			ipRef->journal="Phys. Rev. Ill, 6 (1958) 1518-1521";
			ipRef->comment="dla dlugosci fali 5.4-24.8 um, n = 2e17 cm^-3";
		}
		double tE = 1239.84/iLam; //energia fotonu [eV]
		tAbs300 = 0.04715*pow(tE,-2.6173);
		if ( (iDop == "Si") || (iDop == "Te") || (iDop == "Se") || (iDop == "Sn") || (iDop == "S") ) tAbs300 = tAbs300*iN/2e23; //n-type InP		
	}
	
	return ( tAbs300 );
}
//------------------------------------------------------------------------------
InP::InP()
{
}
//------------------------------------------------------------------------------
InP::~InP()
{
}
//------------------------------------------------------------------------------