#include "pch.h"

#include "Nb2O5.h"
//------------------------------------------------------------------------------
double Nb2O5::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="podano rzad wielkosci";
	}
	return ( 1.0 );
}
//------------------------------------------------------------------------------
double Nb2O5::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="podano rzad wielkosci";
	}
	return ( 1e-7 );
}
//------------------------------------------------------------------------------
double Nb2O5::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="F. Lemarchand, 2013";
		ipRef->title="-";
		ipRef->journal="private communications - refractiveindex.info";
		ipRef->comment="zakres stosowalnosci: 350-650nm";
	}
	if (iLam<350.) iLam = 350.;
	else if (iLam>650.) iLam = 650.;
	iLam *= 1e-3;	//przejscie na um
	double a0 = 1813.982475747902;
	double a1 = -39683.594737809406;
	double a2 = 378240.66284934763;
	double a3 = -2.06067878529E6;
	double a4 = 7.082794738834E6;
	double a5 = -1.59530254905E7;
	double a6 = 2.358140171208E7;
	double a7 = -2.208831930404E7;
	double a8 = 1.191043300989E7;
	double a9 = -2.819720903912E6;
	return ( a0 + a1*iLam + a2*pow(iLam,2.) + a3*pow(iLam,3.) + a4*pow(iLam,4.) + a5*pow(iLam,5.)
		        + a6*pow(iLam,6.)  + a7*pow(iLam,7.) + a8*pow(iLam,8.) + a9*pow(iLam,9.));
}
//------------------------------------------------------------------------------
double Nb2O5::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="L. Gao, F. Lemarchand, and M. Lequime, 2012";
		ipRef->title="Exploitation of multiple incidences spectrometric measurements...";
		ipRef->journal="Opt. Express, 20, 15734-15751 (2012)";
		ipRef->comment="zakres stosowalnosci: 400-550nm";
	}
	if (iLam<350.) iLam = 350.;
	else if (iLam>650.) iLam = 650.;
	iLam *= 1e-3;	//przejscie na um
	double a0 = 42.86165;
	double a1 = -129.68006;
	double a2 = 92.42283;
	return ( exp(a0 + a1*iLam + a2*pow(iLam,2.)));
}
//---------------------------------------------------------------------------
Nb2O5::Nb2O5()
{
}
//---------------------------------------------------------------------------
Nb2O5::~Nb2O5()
{
}


