#include "pch.h"

#include "Ni.h"
//---------------------------------------------------------------------------
double Ni::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="w pracy podano opornosci elektryczne; oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 1. / er(iT) );
}
//---------------------------------------------------------------------------
double Ni::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 5.8e-13*(iT-300.)*(iT-300.) + 4.08e-10*(iT-300.) + 7.19e-8 );
}
//---------------------------------------------------------------------------
double Ni::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2298-2299";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
	return ( 90.3*pow(300./iT,0.423) );
}
//---------------------------------------------------------------------------
double Ni::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 0.445e3 );
}
//---------------------------------------------------------------------------
double Ni::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 8.90e3 );
}
//---------------------------------------------------------------------------
double Ni::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 250nm-6.2um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.083;	f[1]     = 0.357;	f[2]     = 0.039;	f[3]     = 0.127;	f[4]     = 0.654;
	Gamma[0] = 0.022;	Gamma[1] = 2.820;	Gamma[2] = 0.120;	Gamma[3] = 1.822;	Gamma[4] = 6.637;
	w[0]     = 15.92;	w[1]     = 0.317;	w[2]     = 1.059;	w[3]     = 4.583;	w[4]     = 8.825;
	sigma[0] = 0.000;	sigma[1] = 0.606;	sigma[2] = 1.454;	sigma[3] = 0.379;	sigma[4] = 0.510;	
	
	return ( cFunc::getOptPar("nR",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
double Ni::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 250nm-6.2um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.083;	f[1]     = 0.357;	f[2]     = 0.039;	f[3]     = 0.127;	f[4]     = 0.654;
	Gamma[0] = 0.022;	Gamma[1] = 2.820;	Gamma[2] = 0.120;	Gamma[3] = 1.822;	Gamma[4] = 6.637;
	w[0]     = 15.92;	w[1]     = 0.317;	w[2]     = 1.059;	w[3]     = 4.583;	w[4]     = 8.825;
	sigma[0] = 0.000;	sigma[1] = 0.606;	sigma[2] = 1.454;	sigma[3] = 0.379;	sigma[4] = 0.510;	
	
	return ( cFunc::getOptPar("abs",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
Ni::Ni()
{  
}
//---------------------------------------------------------------------------
Ni::~Ni()
{
}