#include "pch.h"

#include "PatiDBR.h"
//---------------------------------------------------------------------------
PatiDBR::PatiDBR(double sklad)
{
	ecRT = sklad;
}
//---------------------------------------------------------------------------
double PatiDBR::ec(double iT, double alfa, double beta, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Michal Wasiak";
		ipRef->title="Przewodnosc elektryczna arsenkowych DBR";
		ipRef->journal="prace wlasne";
		ipRef->comment="wywody Michala - czerwiec 2015";
	}
    return ( ecRT*(1 - beta*exp(-alfa*(iT-300))));
}
//------------------------------------------------------------------------------
double PatiDBR::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Michal Wasiak";
		ipRef->title="Przewodnosc cieplna arsenkowych DBR";
		ipRef->journal="prace wlasne";
		ipRef->comment="zaleznosc od T jak dla GaAs - grudzien 2015";
	} 
	return ( ecRT*pow(300./iT,1.28) );
}
//---------------------------------------------------------------------------
PatiDBR::~PatiDBR()
{
}

