#include "pch.h"

#include "Pd.h"
//---------------------------------------------------------------------------
/*double Pd::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="w pracy podano opornosci elektryczne; oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 1. / er(iT) );
}
//---------------------------------------------------------------------------
double Pd::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return (  );
}
//---------------------------------------------------------------------------
double Pd::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2298-2299";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
	return (  );
}
//---------------------------------------------------------------------------
double Pd::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return (  );
}
//---------------------------------------------------------------------------
double Pd::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return (  );
}*/
//---------------------------------------------------------------------------
double Pd::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-12.4um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.330;	f[1]     = 0.769;	f[2]     = 0.093;	f[3]     = 0.309;	f[4]     = 0.409;
	Gamma[0] = 0.009;	Gamma[1] = 2.343;	Gamma[2] = 0.497;	Gamma[3] = 2.022;	Gamma[4] = 0.119;
	w[0]     = 9.72;	w[1]     = 0.066;	w[2]     = 0.502;	w[3]     = 2.432;	w[4]     = 5.987;
	sigma[0] = 0.000;	sigma[1] = 0.694;	sigma[2] = 0.027;	sigma[3] = 1.167;	sigma[4] = 1.331;	
	
	return ( cFunc::getOptPar("nR",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
double Pd::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 200nm-12.4um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.330;	f[1]     = 0.769;	f[2]     = 0.093;	f[3]     = 0.309;	f[4]     = 0.409;
	Gamma[0] = 0.009;	Gamma[1] = 2.343;	Gamma[2] = 0.497;	Gamma[3] = 2.022;	Gamma[4] = 0.119;
	w[0]     = 9.72;	w[1]     = 0.066;	w[2]     = 0.502;	w[3]     = 2.432;	w[4]     = 5.987;
	sigma[0] = 0.000;	sigma[1] = 0.694;	sigma[2] = 0.027;	sigma[3] = 1.167;	sigma[4] = 1.331;	
	
	return ( cFunc::getOptPar("abs",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
Pd::Pd()
{
}
//---------------------------------------------------------------------------
Pd::~Pd()
{
}
//---------------------------------------------------------------------------
