#include "pch.h"

#include "Pt.h"
//---------------------------------------------------------------------------
double Pt::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="w pracy podano opornosci elektryczne; oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 1. / er(iT) );
}
//---------------------------------------------------------------------------
double Pt::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2121-2123";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
    return ( 3.84e-10*(iT-300.) + 1.071e-7 );
}
//---------------------------------------------------------------------------
double Pt::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2298-2299";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
	return ( 3.6e-5*(iT-300.)*(iT-300.) - 4e-3*(iT-300.) + 71.7 );
}
//---------------------------------------------------------------------------
double Pt::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 0.133e3 );
}
//---------------------------------------------------------------------------
double Pt::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 21.5e3 );
}
//---------------------------------------------------------------------------
double Pt::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 250nm-12.4um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.333;	f[1]     = 0.186;	f[2]     = 0.665;	f[3]     = 0.551;	f[4]     = 2.214;
	Gamma[0] = 0.080;	Gamma[1] = 0.498;	Gamma[2] = 1.851;	Gamma[3] = 2.604;	Gamma[4] = 2.891;
	w[0]     = 9.59;	w[1]     = 0.782;	w[2]     = 1.317;	w[3]     = 3.189;	w[4]     = 8.236;
	sigma[0] = 0.000;	sigma[1] = 0.031;	sigma[2] = 0.096;	sigma[3] = 0.766;	sigma[4] = 1.146;	
	
	return ( cFunc::getOptPar("nR",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
double Pt::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 250nm-12.4um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.333;	f[1]     = 0.186;	f[2]     = 0.665;	f[3]     = 0.551;	f[4]     = 2.214;
	Gamma[0] = 0.080;	Gamma[1] = 0.498;	Gamma[2] = 1.851;	Gamma[3] = 2.604;	Gamma[4] = 2.891;
	w[0]     = 9.59;	w[1]     = 0.782;	w[2]     = 1.317;	w[3]     = 3.189;	w[4]     = 8.236;
	sigma[0] = 0.000;	sigma[1] = 0.031;	sigma[2] = 0.096;	sigma[3] = 0.766;	sigma[4] = 1.146;	
	
	return ( cFunc::getOptPar("abs",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
Pt::Pt()
{  
}
//---------------------------------------------------------------------------
Pt::~Pt()
{
}