#include "pch.h"

#include "Si.h"
//---------------------------------------------------------------------------
double Si::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Eiji Yamasuea, Masahiro Susa, Hiroyuki Fukuyama, Kazuhiro Nagata";
		ipRef->title="Thermal conductivities of silicon and germanium in solid and ...";
		ipRef->journal="Journal of Crystal Growth 234 (2002) 121131";
		ipRef->comment="wzor podany w pracy dla czesci fononowej dominujacej ponizej 1000 K";
	}
	return ( 1/(2.92e-5 + 1.897e-5 * iT + 1.403e-8 * iT * iT));
}
//---------------------------------------------------------------------------
double Si::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author = "KennethC. Mills and Lee Courtney";
		ipRef->title = "Thermophysical Properties of Silicon ...";
		ipRef->journal = "ISIJ International, Vol. 40 (2000), Supplement, pp. S130-S13";
		ipRef->comment = "patrz takze: https://periodictable.com/Elements/014/data.html";
	}
	return ( 0.71e3 );
}
//---------------------------------------------------------------------------
double Si::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author = "KennethC. Mills and Lee Courtney";
		ipRef->title = "Thermophysical Properties of Silicon ...";
		ipRef->journal = "ISIJ International, Vol. 40 (2000), Supplement, pp. S130-S13";
		ipRef->comment = "patrz takze: https://periodictable.com/Elements/014/data.html";
	}
	return ( 2.33e3 );
}
//---------------------------------------------------------------------------
Si::Si()
{ 
}
//---------------------------------------------------------------------------
Si::~Si()
{
}