#include "pch.h"

#include "Si3N4.h"
//---------------------------------------------------------------------------
double Si3N4::cte(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J.F. Shackelford, W. Alexander, eds.";
		ipRef->title="CRC Materials Science and Engineering Handbook";
		ipRef->journal="CRC Press Third Edition, 2001";
		ipRef->comment="wartosc dla T = 300 K";
	}
    return ( 2.9e-6 );
}
//---------------------------------------------------------------------------
double Si3N4::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J.F. Shackelford, W. Alexander, eds.";
		ipRef->title="CRC Materials Science and Engineering Handbook";
		ipRef->journal="CRC Press Third Edition, 2001";
		ipRef->comment="wartosc dla T = 300 K";
	}
	return ( 0.7118e3 );
}
//---------------------------------------------------------------------------
double Si3N4::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="J.F. Shackelford, W. Alexander, eds.";
		ipRef->title="CRC Materials Science and Engineering Handbook";
		ipRef->journal="CRC Press Third Edition, 2001";
		ipRef->comment="wartosc dla T = 300 K";
	}
	return ( 3.184e3 );
}
//---------------------------------------------------------------------------
double Si3N4::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="http://refractiveindex.info/";
		ipRef->comment="zaleznosc dla 0.207-1.24um";
	}
	
	return ( pow((1+2.8939*(iLam/1e3)*(iLam/1e3)/((iLam/1e3)*(iLam/1e3)-0.13967*0.13967)),0.5) );
}
//---------------------------------------------------------------------------
double Si3N4::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Zhou, W. Liu, C. Cai, H. Liu";
		ipRef->title="Comparative investigation of infrared optical absorption properties of silicon oxide, oxynitride and nitride films";
		ipRef->journal="Proc. SPIE 7995 (2011) 79950T";
		ipRef->comment="dla SiNx dla dlugosci fali 9-11 um";
	}
	
	return ( 1.06E-4*pow((iLam/1e3),7.8) );
}
//---------------------------------------------------------------------------
Si3N4::Si3N4()
{
}
//---------------------------------------------------------------------------
Si3N4::~Si3N4()
{
}
//---------------------------------------------------------------------------
