#include "pch.h"

#include "SiNx.h"
//------------------------------------------------------------------------------
double SiNx::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Amy Marconnet, Matt Panzer,..., and K. E. Goodson";
		ipRef->title="Thermal conductivity and photoluminescence of light-emitting silicon nitride films";
		ipRef->journal="APPLIED PHYSICS LETTERS 100, 051908, 2012";
		ipRef->comment="wartosc przyblizona";
	}
	return ( 2.0 );
}
//------------------------------------------------------------------------------
double SiNx::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="zalozono brak przewodzenia";
	}
	return ( 1e-6 );
}
//------------------------------------------------------------------------------
double SiNx::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Duttagupta, F. Ma. B. Hoex, T. Mueller and A. Aberle";
		ipRef->title="Optimised antireflection coatings using silicon nitride on ... and multidimensional modeling";
		ipRef->journal="Energy Procedia 15(0), pp. 7883, 2012 (refractive.index.info)";
		ipRef->comment="zakres stosowalnosci: 300-800 nm";
	}
	if (iLam<300.) iLam = 300.;
	else if (iLam>800.) iLam = 800.;
	double y0 = 1.89081;
	double A1 = 0.32801;
	double t1 = 152.77374;
	double A2 = 0.20741;
	double t2 = 287.54664;
	double A3 = 9.54811;
	double t3 = 58.0479;
	return ( y0 + A1*exp(-iLam/t1) + A2*exp(-iLam/t2) + A3*exp(-iLam/t3) );
}
//------------------------------------------------------------------------------
double SiNx::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Duttagupta, F. Ma. B. Hoex, T. Mueller and A. Aberle";
		ipRef->title="Optimised antireflection coatings using silicon nitride on ... and multidimensional modeling";
		ipRef->journal="Energy Procedia 15(0), pp. 7883, 2012 (refractive.index.info)";
		ipRef->comment="zakres stosowalnosci: 350-550 nm";
	}
	if (iLam<350.) iLam = 350.;
	else if (iLam>550.) iLam = 550.;
	double y0 = 0.00014;
	double A1 = 0.00108;
	double t1 = 218.19921;
    return ( y0 + A1*exp(-iLam/t1) );
} 
//---------------------------------------------------------------------------
SiNx::SiNx()
{
}
//---------------------------------------------------------------------------
SiNx::~SiNx()
{
}


