#include "pch.h"

#include "SiO2.h"
//------------------------------------------------------------------------------
double SiO2::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Rongjie He and Bo Sun";
		ipRef->title="Thermal conductivity of SiO2 grown by plasma";
		ipRef->journal="J. Appl. Phys. 137, 175109 (2025); doi: 10.1063/5.0246816";
		ipRef->comment="dla chemicznego osadzania z fazy gazowej wspomaganego plazm (PECVD)";
	}
	return ( 1.12 );
}
//------------------------------------------------------------------------------
double SiO2::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="podano rzad wielkosci";
	}
	return ( 1e-7 );
}
//------------------------------------------------------------------------------
double SiO2::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="L. Gao, F. Lemarchand, M. Lequime";
		ipRef->title="Refractive index determination of SiO2 layer ...";
		ipRef->journal="J. Europ. Opt. Soc. Rap. Public., 8, 13010 (2013)";
		ipRef->comment="zakres stosowalnosci: 252nm-1.25um";
	}
	if (iLam<252.) iLam = 252.;
	else if (iLam>1250.) iLam = 1250.;
	iLam *= 1e-3;	//przejscie na um
	double a0 = 2.12484889088;
	double a1 = -6.465517090991;
	double a2 = 29.057925618685;
	double a3 = -72.583042786593;
	double a4 = 103.997831683151;
	double a5 = -80.181275213276;
	double a6 = 25.837908586902;
	return ( a0 + a1*iLam + a2*pow(iLam,2.) + a3*pow(iLam,3.) + a4*pow(iLam,4.) + a5*pow(iLam,5.) + a6*pow(iLam,6.) );
}
//------------------------------------------------------------------------------
double SiO2::abs(double iLam, double iT, reference *ipRef)
{
	double Pi = 3.14159265358979;

	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author = "L. Gao, F. Lemarchand, M. Lequime";
		ipRef->title = "Refractive index determination of SiO2 layer ...";
		ipRef->journal = "J. Europ. Opt. Soc. Rap. Public., 8, 13010 (2013)";
		ipRef->comment = "zakres stosowalnosci: 252nm-1.25um";
	}

	if (iLam < 252.) iLam = 252.;
	else if (iLam > 410.) iLam = 410.;
	iLam *= 1e-3;	//przejscie na um
	double a0 = 0.02235362;
	double a1 = -0.18881460;
	double a2 = 0.61625649;
	double a3 = -0.93571855;
	double a4 = 0.56477431;
	double k = a0 + a1 * iLam + a2 * pow(iLam, 2.) + a3 * pow(iLam, 3.) + a4 * pow(iLam, 4.);

	return ( 4*Pi*k/(iLam*0.0001) );
}
//---------------------------------------------------------------------------
double SiO2::cp(double iT, reference* ipRef)
{
	if (ipRef != NULL)
	{
		ipRef->reset();
		ipRef->author = "Rongjie He and Bo Sun";
		ipRef->title = "Thermal conductivity of SiO2 grown by plasma";
		ipRef->journal = "J. Appl. Phys. 137, 175109 (2025); doi: 10.1063/5.0246816";
		ipRef->comment = "dla chemicznego osadzania z fazy gazowej wspomaganego plazm (PECVD)";
	}
	return (0.703e3);
}
//---------------------------------------------------------------------------
double SiO2::g(double iT, reference* ipRef)
{
	if (ipRef != NULL)
	{
		ipRef->reset();
		ipRef->author = "Rongjie He and Bo Sun";
		ipRef->title = "Thermal conductivity of SiO2 grown by plasma";
		ipRef->journal = "J. Appl. Phys. 137, 175109 (2025); doi: 10.1063/5.0246816";
		ipRef->comment = "dla chemicznego osadzania z fazy gazowej wspomaganego plazm (PECVD)";
	}
	return (2.2e3);
}
SiO2::SiO2()
{
}
//---------------------------------------------------------------------------
SiO2::~SiO2()
{
}


