#include "pch.h"

#include "Ta2O5.h"
//------------------------------------------------------------------------------
double Ta2O5::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A. Farsi, M. Siciliani de Cumis, F. Marino, F. Marin";
		ipRef->title="Photothermal and thermo-refractive effects in high reflectivity mirrors at room and cryogenic temperature";
		ipRef->journal="J. Appl. Phys. 111, 043101 (2012)";
		ipRef->comment="wiele prac podaje wartosc od 0.026 do takiej jak dla Al2O3 - 33 W/(m*K)";
	}
	return ( 0.4 );
}
//------------------------------------------------------------------------------
double Ta2O5::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="podano rzad wielkosci";
	}
	return ( 1e-7 );
}
//------------------------------------------------------------------------------
double Ta2O5::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="L. Gao, F. Lemarchand, and M. Lequime, 2012";
		ipRef->title="Exploitation of multiple incidences spectrometric measurements...";
		ipRef->journal="Opt. Express, 20, 15734-15751 (2012)";
		ipRef->comment="zakres stosowalnosci: 350-650nm";
	}
	if (iLam<350.) iLam = 350.;
	else if (iLam>650.) iLam = 650.;
	iLam *= 1e-3;	//przejscie na um
	double a0 = 11.125319027692;
	double a1 = -89.02199924495;
	double a2 = 383.938237467143;
	double a3 = -905.765055787872;
	double a4 = 1219.139904289192;
	double a5 = -882.417095966496;
	double a6 = 267.375806949753;
	return ( a0 + a1*iLam + a2*pow(iLam,2.) + a3*pow(iLam,3.) + a4*pow(iLam,4.) + a5*pow(iLam,5.) + a6*pow(iLam,6.) );
}
//------------------------------------------------------------------------------
double Ta2O5::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="L. Gao, F. Lemarchand, and M. Lequime, 2012";
		ipRef->title="Exploitation of multiple incidences spectrometric measurements...";
		ipRef->journal="Opt. Express, 20, 15734-15751 (2012)";
		ipRef->comment="zakres stosowalnosci: 350-650nm";
	}
	if (iLam<350.) iLam = 350.;
	else if (iLam>650.) iLam = 650.;
	iLam *= 1e-3;	//przejscie na um
	double a0 = 33227.198877346011;
	double a1 = -351431.16781699099;
	double a2 = 1.574078867871E6;
	double a3 = -3.79988268247E6;
	double a4 = 5.191742031011E6;
	double a5 = -3.794921525858E6;
	double a6 = 1.157011918553E6;
	return ( a0 + a1*iLam + a2*pow(iLam,2.) + a3*pow(iLam,3.) + a4*pow(iLam,4.) + a5*pow(iLam,5.) + a6*pow(iLam,6.) );
}
//---------------------------------------------------------------------------
Ta2O5::Ta2O5()
{
}
//---------------------------------------------------------------------------
Ta2O5::~Ta2O5()
{
}


