#include "pch.h"

#include "Ti.h"
//---------------------------------------------------------------------------
double Ti::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
        ipRef->author="N.D. Milosevic and K.D. Maglic";
        ipRef->title="Thermophysical properties of solid phase titanium in a wide temperature range";
        ipRef->journal="High Temperatures-High Pressures, vol. 37, pp. 187-204, 2008";
        ipRef->comment="w pracy podano wzor na opornosc elektryczna dla T=250-1100K";
	}
    return ( 1. / er(iT) );
}
//---------------------------------------------------------------------------
double Ti::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
        ipRef->author="N.D. Milosevic and K.D. Maglic";
        ipRef->title="Thermophysical properties of solid phase titanium in a wide temperature range";
        ipRef->journal="High Temperatures-High Pressures, vol. 37, pp. 187-204, 2008";
        ipRef->comment="zaleznosc dla T=250-1100K";
	}
    return ( (6.17169 + 9.010579e-2*iT + 1.817669e-4*iT*iT - 1.225226e-7*iT*iT*iT) * 1e-8 );
}
//---------------------------------------------------------------------------
double Ti::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 2298-2299";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 200-500K: Lukasz Piskorski";
	}
	return ( 22.00*pow(300./iT,0.24) );
}
//---------------------------------------------------------------------------
double Ti::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 0.522e3 );
}
//---------------------------------------------------------------------------
double Ti::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 12, pp. 219 (in pdf: 2296)";
		ipRef->comment="wartosc dla 25C";
	}
	return ( 4.51e3 );
}
//---------------------------------------------------------------------------
double Ti::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 480nm-20.7um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.126;	f[1]     = 0.427;	f[2]     = 0.218;	f[3]     = 0.513;	f[4]     = 0.0002;
	Gamma[0] = 0.067;	Gamma[1] = 1.877;	Gamma[2] = 0.100;	Gamma[3] = 0.615;	Gamma[4] = 4.109;
	w[0]     = 7.29;	w[1]     = 1.459;	w[2]     = 2.661;	w[3]     = 0.805;	w[4]     = 19.86;
	sigma[0] = 0.000;	sigma[1] = 0.463;	sigma[2] = 0.506;	sigma[3] = 0.799;	sigma[4] = 2.854;
	
	return ( cFunc::getOptPar("nR",iLam,n-1,f,Gamma,w,sigma) );
}
//---------------------------------------------------------------------------
double Ti::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.D. Rakic, A.B. Djurisic, J.M. Elazar, and M.L. Majewski";
		ipRef->title="Optical properties of metallic films for vertical-cavity optoelectronic devices";
		ipRef->journal="Applied Optics, vol. 37, no. 22, pp. 5271-5283, 1998";
		ipRef->comment="obliczono na podstawie modelu Brendela-Bormanna; 480nm-20.7um";
	}
	
	int n=5;
	std::vector<double> f(n), Gamma(n), w(n), sigma(n);

	f[0]     = 0.126;	f[1]     = 0.427;	f[2]     = 0.218;	f[3]     = 0.513;	f[4]     = 0.0002;
	Gamma[0] = 0.067;	Gamma[1] = 1.877;	Gamma[2] = 0.100;	Gamma[3] = 0.615;	Gamma[4] = 4.109;
	w[0]     = 7.29;	w[1]     = 1.459;	w[2]     = 2.661;	w[3]     = 0.805;	w[4]     = 19.86;
	sigma[0] = 0.000;	sigma[1] = 0.463;	sigma[2] = 0.506;	sigma[3] = 0.799;	sigma[4] = 2.854;	
	
	return ( cFunc::getOptPar("abs",iLam,n-1,f,Gamma,w,sigma) );
}
//------------------------------------------------------------------------------
Ti::Ti()
{  
}
//------------------------------------------------------------------------------
Ti::~Ti()
{
}