#include "pch.h"

#include "TiO2.h"
//------------------------------------------------------------------------------
double TiO2::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="podano rzad wielkosci";
	}
	return ( 1.0 );
}
//------------------------------------------------------------------------------
double TiO2::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="podano rzad wielkosci";
	}
	return ( 1e-7 );
}
//------------------------------------------------------------------------------
double TiO2::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Ehsan Hashemi, 2016";
		ipRef->title="-";
		ipRef->journal="private communications - Asa Haglund and Ehsan Hashemi";
		ipRef->comment="zakres stosowalnosci: 380-550nm";
	}
	if (iLam<380.) iLam = 380.;
	else if (iLam>550.) iLam = 550.;
	//iLam w nm
	double a0 = 205.915764003673;
	double a1 = -2.10285913462701;
	double a2 = 0.00872973058925038;
	double a3 = -1.81546534004891E-5;
	double a4 = 1.88850342917244E-8;
	double a5 = -7.85437430990189E-12;
	
	return ( a0 + a1*iLam + a2*pow(iLam,2.) + a3*pow(iLam,3.) + a4*pow(iLam,4.) + a5*pow(iLam,5.));
}
//------------------------------------------------------------------------------
double TiO2::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Ehsan Hashemi, 2016";
		ipRef->title="-";
		ipRef->journal="private communications - Asa Haglund and Ehsan Hashemi";
		ipRef->comment="zakres stosowalnosci: 380-550nm";
	}
	if (iLam<380.) iLam = 380.;
	else if (iLam>550.) iLam = 550.;
	//iLam w nm
	//brak absorpcji dla standardowego TiO2
	double a0 = 0.0;
	return ( a0);
}
//---------------------------------------------------------------------------
TiO2::TiO2()
{
}
//---------------------------------------------------------------------------
TiO2::~TiO2()
{
}


